/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hashi;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.hashi.Bridge;
import pencilbox.hashi.Pier;

public class Board
extends BoardBase {
    static final int UNDECIDED_NUMBER = 9;
    private Pier[][] pier;
    private Bridge[][] bridgeV;
    private Bridge[][] bridgeH;
    private int maxChain;
    private int nPier;
    private int nBridge;
    static final String ERR_CROSS_BRIDGE = "\u6a4b\u304c\u4ea4\u5dee\u3057\u3066\u3044\u308b\n";
    static final String YET_MULTIPLE_LINE = "\u5168\u4f53\u304c\u3072\u3068\u3064\u306a\u304c\u308a\u306b\u306a\u3063\u3066\u3044\u306a\u3044\n";
    static final String ERR_WRONG_NUMBER = "\u6a4b\u306e\u6570\u304c\u6570\u5b57\u3068\u4e00\u81f4\u3057\u3066\u3044\u306a\u3044\n";

    protected void setup() {
        super.setup();
        this.bridgeV = new Bridge[this.rows()][this.cols()];
        this.bridgeH = new Bridge[this.rows()][this.cols()];
        this.pier = new Pier[this.rows()][this.cols()];
        this.maxChain = 1;
        this.nPier = 0;
        this.nBridge = 0;
    }

    public void clearBoard() {
        super.clearBoard();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isPier(r, c)) {
                    this.pier[r][c].clear();
                }
                ++c;
            }
            ++r;
        }
    }

    public void initBoard() {
        this.initChain();
    }

    public void setNumber(int r, int c, int n) {
        if (n == 0) {
            if (this.isPier(r, c)) {
                this.removePier(r, c);
            }
        } else if (n > 0) {
            if (this.isPier(r, c)) {
                this.pier[r][c].setNumber(n);
            } else {
                this.addPier(r, c, n);
            }
        }
    }

    public int getNumber(int r, int c) {
        if (this.pier[r][c] == null) {
            return 0;
        }
        return this.pier[r][c].getNumber();
    }

    public boolean isPier(int r, int c) {
        return this.pier[r][c] != null;
    }

    public boolean isPier(Address pos) {
        return this.isPier(pos.r(), pos.c());
    }

    public int getState(int r, int c) {
        int ret = 0;
        if (this.bridgeV[r][c] != null) {
            ret += this.bridgeV[r][c].getBridge();
        }
        if (this.bridgeH[r][c] != null) {
            ret += this.bridgeH[r][c].getBridge() << 2;
        }
        return ret;
    }

    public void setState(int r, int c, int n) {
        if (this.bridgeV[r][c] != null) {
            this.bridgeV[r][c].setBridge(n & 3);
        }
        if (this.bridgeH[r][c] != null) {
            this.bridgeH[r][c].setBridge(n >> 2 & 3);
        }
    }

    public int getVertBridge(int r, int c) {
        if (this.bridgeV[r][c] == null) {
            return -1;
        }
        return this.bridgeV[r][c].getBridge();
    }

    public int getHorizBridge(int r, int c) {
        if (this.bridgeH[r][c] == null) {
            return -1;
        }
        return this.bridgeH[r][c].getBridge();
    }

    public boolean hasCrossedBridge(int r, int c) {
        return this.getHorizBridge(r, c) > 0 && this.getVertBridge(r, c) > 0;
    }

    public Pier getPier(int r, int c) {
        return this.pier[r][c];
    }

    public Bridge getBridge(int r, int c, int dir) {
        if (dir == 1) {
            return this.bridgeH[r][c];
        }
        if (dir == 0) {
            return this.bridgeV[r][c];
        }
        return null;
    }

    public void setBridge(int r, int c, int dir, Bridge b) {
        if (dir == 1) {
            this.bridgeH[r][c] = b;
        } else if (dir == 0) {
            this.bridgeV[r][c] = b;
        }
    }

    void setBridge(Address pos0, Address pos1, int d, Bridge b) {
        Address pos = new Address(pos0);
        while (true) {
            pos.move(d);
            if (pos.equals(pos1)) break;
            this.setBridge(pos.r(), pos.c(), d & 1, b);
        }
    }

    void addPier(int r, int c, int n) {
        Pier p;
        this.pier[r][c] = p = new Pier(r, c, n);
        int d = 0;
        while (d < 4) {
            Pier next = this.findPier(r, c, d);
            if (next != null) {
                next.setNextPier(d ^ 2, p);
                p.setNextPier(d, next);
                Bridge b = new Bridge(p, next);
                next.setBridge(d ^ 2, b);
                p.setBridge(d, b);
                this.setBridge(p.getPos(), next.getPos(), d, b);
                ++this.nBridge;
            }
            ++d;
        }
        ++this.nPier;
    }

    void removePier(int r, int c) {
        Pier p2;
        Pier p1;
        Pier p = this.pier[r][c];
        int d = 0;
        while (d < 4) {
            p1 = p.getNextPier(d);
            p2 = p.getNextPier(d ^ 2);
            if (p1 != null) {
                if (p2 != null) {
                    p1.setNextPier(d ^ 2, p2);
                } else {
                    p1.setNextPier(d ^ 2, null);
                }
            }
            ++d;
        }
        d = 0;
        while (d < 2) {
            p1 = p.getNextPier(d);
            p2 = p.getNextPier(d ^ 2);
            if (p1 != null) {
                if (p2 != null) {
                    Bridge b = new Bridge(p1, p2);
                    this.setBridge(p2.getPos(), p1.getPos(), d, b);
                    p1.setBridge(d ^ 2, b);
                    p2.setBridge(d, b);
                    --this.nBridge;
                } else {
                    this.setBridge(p.getPos(), p1.getPos(), d, null);
                    p1.setBridge(d ^ 2, null);
                    --this.nBridge;
                }
            } else if (p2 != null) {
                this.setBridge(p.getPos(), p2.getPos(), d ^ 2, null);
                p2.setBridge(d, null);
                --this.nBridge;
            }
            ++d;
        }
        this.pier[r][c] = null;
        --this.nPier;
    }

    void setNBridge(int nBridge) {
        this.nBridge = nBridge;
    }

    int getNBridge() {
        return this.nBridge;
    }

    void setNPier(int nPier) {
        this.nPier = nPier;
    }

    int getNPier() {
        return this.nPier;
    }

    int getMaxChain() {
        return this.maxChain;
    }

    Pier findPier(int r, int c, int direction) {
        Address pos = new Address(r, c);
        pos.move(direction);
        while (this.isOn(pos)) {
            if (this.isPier(pos)) {
                return this.pier[pos.r()][pos.c()];
            }
            pos.move(direction);
        }
        return null;
    }

    public void addBridge(int r, int c, int direction) {
        if (!this.isPier(r, c)) {
            return;
        }
        if (this.pier[r][c].getNextPier(direction) == null) {
            return;
        }
        if (this.pier[r][c].getNBridge(direction) == 2) {
            return;
        }
        this.pier[r][c].increaseBridge(direction);
        if (this.pier[r][c].getNBridge(direction) == 1) {
            this.connectChain(this.pier[r][c], this.pier[r][c].getNextPier(direction));
        }
    }

    public void removeBridge(int r, int c, int direction) {
        if (!this.isPier(r, c)) {
            return;
        }
        if (this.pier[r][c].getNextPier(direction) == null) {
            return;
        }
        if (this.pier[r][c].getNBridge(direction) == 0) {
            return;
        }
        this.pier[r][c].decreaseBridge(direction);
        if (this.pier[r][c].getNBridge(direction) == 0) {
            this.cutChain(this.pier[r][c], this.pier[r][c].getNextPier(direction));
        }
    }

    public void addBridgeA(int r, int c, int direction) {
        this.addBridge(r, c, direction);
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(r, c, direction, 1)));
    }

    public void removeBridgeA(int r, int c, int direction) {
        this.removeBridge(r, c, direction);
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(r, c, direction, -1)));
    }

    void initChain() {
        int c;
        int r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                if (this.isPier(r, c)) {
                    this.pier[r][c].setChain(0);
                }
                ++c;
            }
            ++r;
        }
        this.maxChain = 1;
        r = 0;
        while (r < this.rows()) {
            c = 0;
            while (c < this.cols()) {
                if (this.isPier(r, c)) {
                    if (this.pier[r][c].totalBridges() == 0) {
                        this.pier[r][c].setChain(0);
                    } else if (this.pier[r][c].getChain() == 0) {
                        this.initChain1(this.pier[r][c], this.maxChain++);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    void initChain1(Pier p, int chain) {
        if (p.getChain() == chain) {
            return;
        }
        p.setChain(chain);
        int d = 0;
        while (d < 4) {
            if (p.getNBridge(d) > 0) {
                this.initChain1(p.getNextPier(d), chain);
            }
            ++d;
        }
    }

    void connectChain(Pier pierA, Pier pierB) {
        int a = pierA.getChain();
        int b = pierB.getChain();
        if (a == 0) {
            if (b == 0) {
                pierA.setChain(this.maxChain);
                pierB.setChain(this.maxChain++);
            } else if (b > 0) {
                pierA.setChain(b);
            }
        } else if (a > 0) {
            if (b == 0) {
                pierB.setChain(a);
            } else if (b > 0) {
                this.initChain1(pierB, a);
            }
        }
    }

    void cutChain(Pier pierA, Pier pierB) {
        int a = pierA.totalBridges();
        int b = pierB.totalBridges();
        if (a == 0) {
            pierA.setChain(0);
            if (b == 0) {
                pierB.setChain(0);
            }
        } else if (a > 0) {
            if (b == 0) {
                pierB.setChain(0);
            } else if (b > 0) {
                this.initChain1(pierB, this.maxChain++);
            }
        }
    }

    public int checkPier(int r, int c) {
        int number = this.pier[r][c].getNumber();
        int bridges = this.pier[r][c].totalBridges();
        if (number == 9) {
            return 1;
        }
        return number - bridges;
    }

    public int checkAnswerCode() {
        int result = 0;
        if (!this.checkCross()) {
            result |= 1;
        }
        if (!this.checkConnection()) {
            result |= 2;
        }
        if (!this.checkNumbers()) {
            result |= 4;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return "\u6b63\u89e3\u3067\u3059";
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append(ERR_CROSS_BRIDGE);
        }
        if ((result & 2) == 2) {
            message.append(YET_MULTIPLE_LINE);
        }
        if ((result & 4) == 4) {
            message.append(ERR_WRONG_NUMBER);
        }
        return message.toString();
    }

    private boolean checkNumbers() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isPier(r, c) && this.pier[r][c].getNumber() != 9 && this.pier[r][c].totalBridges() != this.pier[r][c].getNumber()) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    private boolean checkConnection() {
        int n = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isPier(r, c)) {
                    int m = this.pier[r][c].getChain();
                    if (m == 0) {
                        return false;
                    }
                    if (n == 0) {
                        n = m;
                    } else if (n != m) {
                        return false;
                    }
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    private boolean checkCross() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.hasCrossedBridge(r, c)) {
                    return false;
                }
                ++c;
            }
            ++r;
        }
        return true;
    }

    int sumAllNumbers() {
        int ret = 0;
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.isPier(r, c)) {
                    ret += this.pier[r][c].getNumber();
                }
                ++c;
            }
            ++r;
        }
        return ret / 2;
    }

    class Step
    extends AbstractUndoableEdit {
        static final int ADDED = 1;
        static final int REMOVED = -1;
        int row;
        int col;
        int direction;
        int change;

        public Step(int r, int c, int dir, int ch) {
            this.row = r;
            this.col = c;
            this.direction = dir;
            this.change = ch;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.change == 1) {
                Board.this.removeBridge(this.row, this.col, this.direction);
            } else if (this.change == -1) {
                Board.this.addBridge(this.row, this.col, this.direction);
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (this.change == 1) {
                Board.this.addBridge(this.row, this.col, this.direction);
            } else if (this.change == -1) {
                Board.this.removeBridge(this.row, this.col, this.direction);
            }
        }
    }
}

