/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kakuro;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.CellCursor;
import pencilbox.common.gui.HintDot;
import pencilbox.common.gui.PanelBase;
import pencilbox.kakuro.Board;
import pencilbox.kakuro.KakuroCursor;

public class Panel
extends PanelBase {
    private Board board;
    private boolean indicateErrorMode = false;
    private boolean dotHintMode = false;
    private Color inputColor = Color.BLUE;
    private Color wallColor = new Color(0xC0C0C0);
    private Font smallFont = new Font("SansSerif", 0, 13);
    private HintDot hintDot = new HintDot();

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setCursorMode(true);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.hintDot.setDot(this, 3, this.getCellSize());
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setInputColor(Color inputColor) {
        this.inputColor = inputColor;
    }

    public void setWallColor(Color wallColor) {
        this.wallColor = wallColor;
    }

    public Color getWallColor() {
        return this.wallColor;
    }

    public boolean isDotHintMode() {
        return this.dotHintMode;
    }

    public void setDotHintMode(boolean dotHintMode) {
        this.dotHintMode = dotHintMode;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public void setDisplaySize(int size) {
        super.setDisplaySize(size);
        this.smallFont = new Font("SansSerif", 0, this.getCellSize() / 2);
        this.hintDot.setDotSize(this.getCellSize());
    }

    public CellCursor createCursor() {
        return new KakuroCursor();
    }

    public void drawBoard(Graphics2D g) {
        this.drawWalls(g);
        this.drawNumbers(g);
        this.drawGrid(g);
        this.drawBoardBorder(g);
    }

    private void drawWalls(Graphics2D g) {
        g.setFont(this.smallFont);
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                if (this.board.isWall(r, c)) {
                    this.drawWall(g, r, c, this.board.getSumH(r, c), this.board.getSumV(r, c));
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int number = this.board.getNumber(r, c);
                if (number > 0) {
                    g.setColor(this.getInputColor());
                    if (this.isIndicateErrorMode() && this.board.isMultipleNumber(r, c)) {
                        g.setColor(this.getErrorColor());
                    }
                    this.placeNumber(g, r, c, number);
                } else if (number == 0 && this.isDotHintMode()) {
                    this.placeHintDot(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    void drawWall(Graphics2D g, int r, int c, int a, int b) {
        g.setColor(this.getWallColor());
        this.paintCell(g, r, c);
        g.setColor(this.getGridColor());
        this.edgeCell(g, r, c);
        g.drawLine(this.toX(c), this.toY(r), this.toX(c + 1), this.toY(r + 1));
        if (b > 0) {
            g.setColor(this.getNumberColor());
            if (this.isIndicateErrorMode() && this.board.getWordStatus(r, c, 0) == -1) {
                g.setColor(this.getErrorColor());
            }
            this.drawString(g, this.toX(c) + this.getHalfCellSize() / 2 + 1, this.toY(r + 1) - this.getHalfCellSize() / 2, Integer.toString(b));
        }
        if (a > 0) {
            g.setColor(this.getNumberColor());
            if (this.isIndicateErrorMode() && this.board.getWordStatus(r, c, 1) == -1) {
                g.setColor(this.getErrorColor());
            }
            this.drawString(g, this.toX(c + 1) - this.getHalfCellSize() / 2, this.toY(r) + this.getHalfCellSize() / 2 + 1, Integer.toString(a));
        }
    }

    public void drawCursor(Graphics2D g) {
        super.drawCursor(g);
        if (this.isProblemEditMode()) {
            KakuroCursor kcursor = (KakuroCursor)this.getCellCursor();
            g.drawRect(this.toX(kcursor.c()) + kcursor.getStair() * this.getHalfCellSize(), this.toY(kcursor.r()) + (kcursor.getStair() ^ 1) * this.getHalfCellSize(), this.getHalfCellSize(), this.getHalfCellSize());
        }
    }

    void placeHintDot(Graphics2D g, int r, int c) {
        if (this.board.getRemNo(r, c) == 0) {
            this.hintDot.placeHintCross(g, r, c);
        } else {
            this.hintDot.placeHintDot(g, r, c, this.board.getRemPattern(r, c));
        }
    }
}

