/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.nurikabe;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.nurikabe.Panel;

public class Menu
extends MenuBase {
    private JMenuItem numberColorItem;
    private JMenuItem paintColorItem;
    private JMenuItem circleColorItem;
    private JMenuItem countAreaSizeItem;
    private JMenuItem separateAreaColorItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    protected void buildEditMenu() {
        this.addSymmetricPlacementMenuItem();
        this.addTrimAnswerMenuItem();
        super.buildEditMenu();
    }

    protected void buildViewMenu() {
        this.addNoPaintMarkStyleMenu();
        super.buildViewMenu();
        this.numberColorItem = this.addColorMenuItem("\u6570\u5b57");
        this.paintColorItem = this.addColorMenuItem("\u9ed2\u30de\u30b9");
        this.circleColorItem = this.addColorMenuItem("\u767d\u30de\u30b9");
        this.separateAreaColorItem = this.makeCheckBoxCommandMenuItem("\u58c1\u306e\u8272\u5206\u3051(R)", 'R', false);
        this.addToViewMenu(this.separateAreaColorItem);
        this.countAreaSizeItem = this.makeCheckBoxCommandMenuItem("\u30b7\u30de\u306e\u30de\u30b9\u6570\u3092\u6570\u3048\u308b(C)", 'C', false);
        this.addToViewMenu(this.countAreaSizeItem);
        this.addRenewColorMenuItem();
    }

    public void executeCommand2(JMenuItem target) {
        if (target == this.countAreaSizeItem) {
            this.getPanel().setCountAreaSizeMode(target.isSelected());
        } else if (target == this.separateAreaColorItem) {
            this.getPanel().setSeparateAreaColorMode(target.isSelected());
        }
    }

    public Color getColor(JMenuItem target) {
        if (target == this.paintColorItem) {
            return this.getPanel().getPaintColor();
        }
        if (target == this.circleColorItem) {
            return this.getPanel().getCircleColor();
        }
        if (target == this.numberColorItem) {
            return this.getPanel().getNumberColor();
        }
        return super.getColor(target);
    }

    public void setColor(JMenuItem target, Color color) {
        if (target == this.paintColorItem) {
            this.getPanel().setPaintColor(color);
        } else if (target == this.circleColorItem) {
            this.getPanel().setCircleColor(color);
        } else if (target == this.numberColorItem) {
            this.getPanel().setNumberColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.separateAreaColorItem.setSelected(this.getPanel().isSeparateAreaColorMode());
        this.countAreaSizeItem.setSelected(this.getPanel().isCountAreaSizeMode());
    }
}

