/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.nurikabe;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.nurikabe.Area;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    public static final int SPACE = -1;
    public static final int WALL = -2;
    public static final int UNKNOWN = 0;
    public static final int UNDECIDED_NUMBER = -3;
    private int[][] state;
    private Area[][] area;
    private List areaList;
    private Area initializingArea;

    protected void setup() {
        super.setup();
        this.state = new int[this.rows()][this.cols()];
        this.area = new Area[this.rows()][this.cols()];
        this.areaList = new LinkedList();
    }

    public void clearBoard() {
        super.clearBoard();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (!this.isNumber(r, c)) {
                    this.state[r][c] = 0;
                }
                ++c;
            }
            ++r;
        }
        this.initBoard();
    }

    public void trimAnswer() {
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.state[r][c] == -1) {
                    this.state[r][c] = 0;
                }
                ++c;
            }
            ++r;
        }
        this.initBoard();
    }

    int[][] getState() {
        return this.state;
    }

    public int getState(int r, int c) {
        return this.state[r][c];
    }

    public void setState(int r, int c, int st) {
        this.state[r][c] = st;
    }

    public boolean isNumber(int r, int c) {
        return this.isOn(r, c) && (this.state[r][c] > 0 || this.state[r][c] == -3);
    }

    public boolean isWall(int r, int c) {
        return this.isOn(r, c) && this.state[r][c] == -2;
    }

    public boolean isUnknown(int r, int c) {
        return this.state[r][c] == 0;
    }

    public int getSpaceOrWall(int r, int c) {
        if (this.state[r][c] > 0) {
            return -1;
        }
        if (this.state[r][c] == -3) {
            return -1;
        }
        return this.state[r][c];
    }

    public boolean isSpaceOrNumber(int r, int c) {
        return this.isOn(r, c) && (this.state[r][c] > 0 || this.state[r][c] == -1 || this.state[r][c] == -3);
    }

    public void initBoard() {
        this.initAreas();
    }

    public void initAreas() {
        ArrayUtil.initArrayObject2(this.area, null);
        this.areaList.clear();
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.getState(r, c) != 0 && this.area[r][c] == null) {
                    this.initArea(r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    void initArea(int r, int c) {
        this.initializingArea = this.makeNewArea(r, c);
        this.initializingArea.add(r, c);
        this.setArea(r, c, this.initializingArea);
        if (this.isNumber(r, c)) {
            this.initializingArea.addNumber(this.getState(r, c));
        }
        this.areaList.add(this.initializingArea);
        this.initArea1(r, c);
    }

    private void initArea1(int r, int c) {
        if (this.initArea2(r - 1, c)) {
            this.initArea1(r - 1, c);
        }
        if (this.initArea2(r, c - 1)) {
            this.initArea1(r, c - 1);
        }
        if (this.initArea2(r + 1, c)) {
            this.initArea1(r + 1, c);
        }
        if (this.initArea2(r, c + 1)) {
            this.initArea1(r, c + 1);
        }
    }

    private boolean initArea2(int r, int c) {
        if (!this.isOn(r, c)) {
            return false;
        }
        if (this.getSpaceOrWall(r, c) != this.initializingArea.getAreaType()) {
            return false;
        }
        if (this.getArea(r, c) == this.initializingArea) {
            return false;
        }
        this.initializingArea.add(r, c);
        if (this.isNumber(r, c)) {
            this.initializingArea.addNumber(this.getState(r, c));
        }
        this.setArea(r, c, this.initializingArea);
        return true;
    }

    public Area getArea(int r, int c) {
        if (!this.isOn(r, c)) {
            return null;
        }
        return this.area[r][c];
    }

    public void setArea(int r, int c, Area a) {
        this.area[r][c] = a;
    }

    public void changeState(int r, int c, int st) {
        int prevSt = this.getSpaceOrWall(r, c);
        this.setState(r, c, st);
        int type = st > 0 ? -1 : st;
        if (prevSt != 0) {
            this.splitArea(r, c, prevSt);
        }
        if (st != 0) {
            this.mergeArea(r, c, type);
        }
    }

    public void changeStateA(int r, int c, int st) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(r, c, this.state[r][c], st)));
        this.changeState(r, c, st);
    }

    public void toggleState(int r, int c, int st) {
        if (this.isNumber(r, c)) {
            return;
        }
        if (this.state[r][c] == st) {
            this.changeStateA(r, c, 0);
        } else {
            this.changeStateA(r, c, st);
        }
    }

    void mergeArea(int r, int c, int type) {
        Area mergedArea = null;
        mergedArea = this.mergeArea1(this.getArea(r - 1, c), mergedArea, type);
        mergedArea = this.mergeArea1(this.getArea(r, c - 1), mergedArea, type);
        mergedArea = this.mergeArea1(this.getArea(r + 1, c), mergedArea, type);
        mergedArea = this.mergeArea1(this.getArea(r, c + 1), mergedArea, type);
        if (mergedArea == null) {
            mergedArea = this.makeNewArea(r, c);
            this.areaList.add(mergedArea);
        }
        mergedArea.add(r, c);
        if (this.isNumber(r, c)) {
            mergedArea.addNumber(this.getState(r, c));
        }
        this.setArea(r, c, mergedArea);
    }

    private Area mergeArea1(Area area, Area mergedArea, int type) {
        if (area != null && area.getAreaType() == type) {
            if (mergedArea == null) {
                mergedArea = area;
            } else if (mergedArea != area) {
                mergedArea.addAll(area);
                Iterator itr = area.iterator();
                while (itr.hasNext()) {
                    Address pos = (Address)itr.next();
                    this.setArea(pos.r(), pos.c(), mergedArea);
                    if (!this.isNumber(pos.r(), pos.c())) continue;
                    mergedArea.addNumber(this.getState(pos.r(), pos.c()));
                }
                this.areaList.remove(area);
            }
        }
        return mergedArea;
    }

    void splitArea(int r, int c, int type) {
        Area oldArea = this.getArea(r, c);
        Area largerArea = null;
        this.areaList.remove(this.getArea(r, c));
        Iterator itr = this.getArea(r, c).iterator();
        while (itr.hasNext()) {
            Address pos = (Address)itr.next();
            this.setArea(pos.r(), pos.c(), null);
        }
        if (this.isOn(r - 1, c) && this.getSpaceOrWall(r - 1, c) == type && this.getArea(r - 1, c) == null) {
            this.initArea(r - 1, c);
            if (largerArea == null || this.initializingArea.size() > largerArea.size()) {
                largerArea = this.initializingArea;
            }
        }
        if (this.isOn(r, c - 1) && this.getSpaceOrWall(r, c - 1) == type && this.getArea(r, c - 1) == null) {
            this.initArea(r, c - 1);
            if (largerArea == null || this.initializingArea.size() > largerArea.size()) {
                largerArea = this.initializingArea;
            }
        }
        if (this.isOn(r + 1, c) && this.getSpaceOrWall(r + 1, c) == type && this.getArea(r + 1, c) == null) {
            this.initArea(r + 1, c);
            if (largerArea == null || this.initializingArea.size() > largerArea.size()) {
                largerArea = this.initializingArea;
            }
        }
        if (this.isOn(r, c + 1) && this.getSpaceOrWall(r, c + 1) == type && this.getArea(r, c + 1) == null) {
            this.initArea(r, c + 1);
            if (largerArea == null || this.initializingArea.size() > largerArea.size()) {
                largerArea = this.initializingArea;
            }
        }
        if (largerArea != null) {
            largerArea.setID(oldArea.getID());
        }
    }

    Area makeNewArea(int r, int c) {
        if (this.isWall(r, c)) {
            return new Area(-2);
        }
        if (this.isSpaceOrNumber(r, c)) {
            return new Area(-1);
        }
        return null;
    }

    boolean is2x2Block(int r, int c) {
        if (this.isWall(r, c)) {
            if (this.isWall(r - 1, c)) {
                if (this.isWall(r, c - 1) && this.isWall(r - 1, c - 1)) {
                    return true;
                }
                if (this.isWall(r, c + 1) && this.isWall(r - 1, c + 1)) {
                    return true;
                }
            }
            if (this.isWall(r + 1, c)) {
                if (this.isWall(r, c - 1) && this.isWall(r + 1, c - 1)) {
                    return true;
                }
                if (this.isWall(r, c + 1) && this.isWall(r + 1, c + 1)) {
                    return true;
                }
            }
        }
        return false;
    }

    public int checkAnswerCode() {
        int result = 0;
        int r = this.rows() - 1;
        while (r >= 0) {
            int c = this.cols() - 1;
            while (c >= 0) {
                if (this.isUnknown(r, c)) {
                    result |= 1;
                }
                if (this.is2x2Block(r, c)) {
                    result |= 0x40;
                }
                --c;
            }
            --r;
        }
        return result |= this.checkAreas();
    }

    private int checkAreas() {
        int ret = 0;
        int blackAreaCount = 0;
        Iterator itr = this.areaList.iterator();
        while (itr.hasNext()) {
            Area area = (Area)itr.next();
            int number = area.getNumber();
            if (area.getAreaType() == -1) {
                if (number == 0) {
                    ret |= 0x10;
                    continue;
                }
                if (number == Area.MULTIPLE_NUMBER) {
                    ret |= 8;
                    continue;
                }
                if (number == -3 || number <= 0) continue;
                if (area.size() < number) {
                    ret |= 4;
                    continue;
                }
                if (area.size() <= number) continue;
                ret |= 2;
                continue;
            }
            if (area.getAreaType() != -2) continue;
            ++blackAreaCount;
        }
        if (blackAreaCount > 1) {
            ret |= 0x20;
        }
        return ret;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return "\u6b63\u89e3\u3067\u3059";
        }
        if (result == 1) {
            return "\u7a7a\u767d\u30de\u30b9\u304c\u3042\u308b\n";
        }
        StringBuffer message = new StringBuffer();
        if ((result & 2) == 2) {
            message.append("\u6570\u5b57\u3088\u308a\u9762\u7a4d\u306e\u5927\u304d\u3044\u30b7\u30de\u304c\u3042\u308b\n");
        }
        if ((result & 4) == 4) {
            message.append("\u6570\u5b57\u3088\u308a\u9762\u7a4d\u306e\u5c0f\u3055\u3044\u30b7\u30de\u304c\u3042\u308b\n");
        }
        if ((result & 8) == 8) {
            message.append("\u6570\u5b57\u3092\u8907\u6570\u542b\u3080\u30b7\u30de\u304c\u3042\u308b\n");
        }
        if ((result & 0x10) == 16) {
            message.append("\u6570\u5b57\u3092\u542b\u307e\u306a\u3044\u30b7\u30de\u304c\u3042\u308b\n");
        }
        if ((result & 0x20) == 32) {
            message.append("\u9ed2\u30de\u30b9\u304c\u8907\u6570\u306b\u5206\u65ad\u3055\u308c\u3066\u3044\u308b\n");
        }
        if ((result & 0x40) == 64) {
            message.append("\u9ed2\u30de\u30b9\u304c\uff12\uff58\uff12\u30de\u30b9\u306e\u304b\u305f\u307e\u308a\u306b\u306a\u3063\u3066\u3044\u308b\n");
        }
        return message.toString();
    }

    class Step
    extends AbstractUndoableEdit {
        private int row;
        private int col;
        private int before;
        private int after;

        public Step(int r, int c, int b, int a) {
            this.row = r;
            this.col = c;
            this.before = b;
            this.after = a;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            Board.this.changeState(this.row, this.col, this.before);
        }

        public void redo() throws CannotRedoException {
            super.redo();
            Board.this.changeState(this.row, this.col, this.after);
        }
    }
}

