/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.yajilin;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.util.Colors;
import pencilbox.yajilin.Board;

public class Panel
extends PanelBase {
    private Board board;
    private boolean indicateErrorMode = false;
    private boolean separateLinkColorMode = false;
    private Color circleColor = Color.MAGENTA;
    private Color lineColor = Color.BLUE;
    private Color paintColor = Color.BLUE;
    private Color crossColor = Color.MAGENTA;

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setMarkStyle(3);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public boolean isSeparateLinkColorMode() {
        return this.separateLinkColorMode;
    }

    public void setSeparateLinkColorMode(boolean separateLinkColorMode) {
        this.separateLinkColorMode = separateLinkColorMode;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setPaintColor(Color blackColor) {
        this.paintColor = blackColor;
    }

    public Color getCrossColor() {
        return this.crossColor;
    }

    public void setCrossColor(Color crossColor) {
        this.crossColor = crossColor;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color whiteColor) {
        this.circleColor = whiteColor;
    }

    public void drawBoard(Graphics2D g) {
        this.drawNumbers(g);
        this.drawGrid(g);
        this.drawLinks(g);
        this.drawBoardBorder(g);
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int state = this.board.getNumber(r, c);
                if (state == -2) {
                    g.setColor(this.getPaintColor());
                    this.paintCell(g, r, c);
                } else if (state == -1) {
                    g.setColor(this.getCircleColor());
                    this.placeMark(g, r, c);
                } else if (state >= 0) {
                    this.placeArrow(g, r, c, state);
                } else if (state == -4) {
                    g.setColor(this.getNumberColor());
                    this.placeBoldCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawLinks(Graphics2D g) {
        int d = 0;
        while (d <= 1) {
            int r = 0;
            while (r < this.board.rows()) {
                int c = 0;
                while (c < this.board.cols()) {
                    int state = this.board.getState(d, r, c);
                    if (state == 1) {
                        g.setColor(this.getLineColor());
                        if (this.isSeparateLinkColorMode()) {
                            g.setColor(Colors.getColor(this.board.getLink(d, r, c).getID()));
                        }
                        this.placeLink(g, d, r, c);
                    }
                    ++c;
                }
                ++r;
            }
            ++d;
        }
    }

    private void placeArrow(Graphics2D g, int r, int c, int arrow) {
        g.setColor(this.getNumberColor());
        if (this.isIndicateErrorMode() && this.board.checkArrow(r, c) == 16) {
            g.setColor(this.getErrorColor());
        }
        int direction = arrow >> 4 & 3;
        int number = arrow & 0xF;
        String arrowS = this.getArrowString(direction);
        String numberS = Integer.toString(number);
        if (direction == 0 || direction == 2) {
            this.drawString(g, this.toX(c + 1) - this.getCellSize() * 1 / 6, this.toY(r) + this.getHalfCellSize(), arrowS);
            this.drawString(g, this.toX(c) + this.getHalfCellSize() - this.getCellSize() * 1 / 12, this.toY(r) + this.getHalfCellSize(), numberS);
        } else if (direction == 1 || direction == 3) {
            this.drawString(g, this.toX(c) + this.getHalfCellSize(), this.toY(r) + this.getCellSize() * 1 / 6, arrowS);
            this.drawString(g, this.toX(c) + this.getHalfCellSize(), this.toY(r) + this.getHalfCellSize() + this.getCellSize() * 1 / 12, numberS);
        }
    }

    private String getArrowString(int direction) {
        switch (direction) {
            case 0: {
                return "\u2191";
            }
            case 2: {
                return "\u2193";
            }
            case 1: {
                return "\u2190";
            }
            case 3: {
                return "\u2192";
            }
        }
        return "";
    }
}

