/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.masyu;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.masyu.Board;
import pencilbox.util.Colors;

public class Panel
extends PanelBase {
    private Board board;
    private boolean separateLinkColorMode = false;
    private boolean indicateErrorMode = false;
    private Color lineColor = Color.BLUE;
    private Color crossColor = Color.MAGENTA;
    private Color grayPearlColor = Color.GRAY;

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color lineColor) {
        this.lineColor = lineColor;
    }

    public Color getCrossColor() {
        return this.crossColor;
    }

    public void setCrossColor(Color crossColor) {
        this.crossColor = crossColor;
    }

    public boolean isSeparateLinkColorMode() {
        return this.separateLinkColorMode;
    }

    public void setSeparateLinkColorMode(boolean separateLinkColorMode) {
        this.separateLinkColorMode = separateLinkColorMode;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public void drawBoard(Graphics2D g) {
        this.drawNumbers(g);
        this.drawGrid(g);
        this.drawLinks(g);
        this.drawBoardBorder(g);
    }

    private void drawNumbers(Graphics2D g) {
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int number = this.board.getNumber(r, c);
                if (number == 1) {
                    this.placeWhitePearl(g, r, c);
                } else if (number == 2) {
                    this.placeBlackPearl(g, r, c);
                } else if (number == 3) {
                    this.placeGrayPearl(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawLinks(Graphics2D g) {
        int d = 0;
        while (d <= 1) {
            int r = 0;
            while (r < this.board.rows()) {
                int c = 0;
                while (c < this.board.cols()) {
                    int state = this.board.getState(d, r, c);
                    if (state == 1) {
                        g.setColor(this.getLineColor());
                        if (this.isSeparateLinkColorMode()) {
                            g.setColor(Colors.getColor(this.board.getLink(d, r, c).getID()));
                        }
                        this.placeLink(g, d, r, c);
                    } else if (state == -1) {
                        g.setColor(this.getCrossColor());
                        this.placeSideCross(g, d, r, c);
                    }
                    ++c;
                }
                ++r;
            }
            ++d;
        }
    }

    private void placeBlackPearl(Graphics2D g, int r, int c) {
        g.setColor(this.getNumberColor());
        if (this.isIndicateErrorMode()) {
            int p = this.board.checkBlackPearl(r, c);
            if (p == -1) {
                g.setColor(this.getErrorColor());
            } else if (p == 0) {
                g.setColor(this.getErrorColor());
            }
        }
        this.placeFilledCircle(g, r, c);
    }

    private void placeWhitePearl(Graphics2D g, int r, int c) {
        g.setColor(this.getNumberColor());
        if (this.isIndicateErrorMode()) {
            int p = this.board.checkWhitePearl(r, c);
            if (p == -1) {
                g.setColor(this.getErrorColor());
            } else if (p == 0) {
                g.setColor(this.getErrorColor());
            }
        }
        this.placeBoldCircle(g, r, c);
    }

    private void placeGrayPearl(Graphics2D g, int r, int c) {
        g.setColor(this.grayPearlColor);
        this.placeFilledCircle(g, r, c);
    }
}

