/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.tentaisho;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.tentaisho.Area;
import pencilbox.tentaisho.Board;
import pencilbox.tentaisho.Panel;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;

    public PanelEventHandler() {
        this.setMaxInputNumber(2);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public boolean isCursorOnBoard(Address pos) {
        return this.board.isOnStar(pos.r(), pos.c());
    }

    Area getDraggingArea() {
        return ((Panel)this.getPanel()).getDraggingArea();
    }

    void setDraggingArea(Area draggingArea) {
        ((Panel)this.getPanel()).setDraggingArea(draggingArea);
    }

    protected void leftPressed(Address pos) {
        Area area = this.board.getArea(pos.r(), pos.c());
        if (area == null) {
            area = new Area();
            this.board.addCellToAreaA(pos.r(), pos.c(), area);
        }
        this.setDraggingArea(area);
    }

    protected void leftDragged(Address pos) {
        Area draggingArea = this.getDraggingArea();
        if (draggingArea == null) {
            return;
        }
        Area oldArea = this.board.getArea(pos.r(), pos.c());
        if (oldArea != null && oldArea != draggingArea) {
            this.board.removeCellFromAreaA(pos.r(), pos.c(), oldArea);
            this.board.addCellToAreaA(pos.r(), pos.c(), draggingArea);
        } else if ((oldArea == null || oldArea != draggingArea) && oldArea == null) {
            this.board.addCellToAreaA(pos.r(), pos.c(), draggingArea);
        }
    }

    protected void rightPressed(Address pos) {
        Area oldArea = this.board.getArea(pos.r(), pos.c());
        if (oldArea != null) {
            this.board.removeCellFromAreaA(pos.r(), pos.c(), oldArea);
        }
    }

    protected void rightDragged(Address pos) {
        this.rightPressed(pos);
    }

    protected void leftDragFixed(Address dragEnd) {
        this.setDraggingArea(null);
    }

    protected void dragFailed() {
        this.setDraggingArea(null);
    }

    protected void moveCursor(Address pos) {
    }

    protected void numberEntered(Address p, int n) {
        if (this.isProblemEditMode() && (n == 2 || n == 1)) {
            this.board.setStar(p.r(), p.c(), n);
        }
    }

    protected void spaceEntered(Address p) {
        if (this.isProblemEditMode()) {
            this.board.setStar(p.r(), p.c(), 0);
        }
    }
}

