/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.tentaisho;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.tentaisho.Area;
import pencilbox.tentaisho.Board;

public class Panel
extends PanelBase {
    private Board board;
    private boolean hideStarMode = false;
    private boolean showAreaBorderMode = true;
    private boolean indicateErrorMode = false;
    private boolean separateAreaColorMode = false;
    private Color areaBorderColor = Color.BLUE;
    private Color noStarAreaColor = new Color(0xFFFF80);
    private Color whiteAreaColor = new Color(0x80FFFF);
    private Color blackAreaColor = new Color(0xFF80FF);
    private Color starColor = Color.BLACK;
    private int halfStarSize = 3;
    private Area draggingArea;

    public Panel() {
        this.setGridColor(Color.GRAY);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    Area getDraggingArea() {
        return this.draggingArea;
    }

    void setDraggingArea(Area draggingArea) {
        this.draggingArea = draggingArea;
    }

    public int getHalfStarSize() {
        return this.halfStarSize;
    }

    public void setHalfStarSize(int halfStarSize) {
        this.halfStarSize = halfStarSize;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getBlackAreaColor() {
        return this.blackAreaColor;
    }

    public void setBlackAreaColor(Color blackAreaColor) {
        this.blackAreaColor = blackAreaColor;
    }

    public Color getWhiteAreaColor() {
        return this.whiteAreaColor;
    }

    public void setWhiteAreaColor(Color whiteAreaColor) {
        this.whiteAreaColor = whiteAreaColor;
    }

    public boolean isShowAreaBorderMode() {
        return this.showAreaBorderMode;
    }

    public void setShowAreaBorderMode(boolean showAreaBorderMode) {
        this.showAreaBorderMode = showAreaBorderMode;
    }

    public boolean isHideStarMode() {
        return this.hideStarMode;
    }

    public void setHideStarMode(boolean hideStarMode) {
        this.hideStarMode = hideStarMode;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public boolean isSeparateAreaColorMode() {
        return this.separateAreaColorMode;
    }

    public void setSeparateAreaColorMode(boolean separateAreaColorMode) {
        this.separateAreaColorMode = separateAreaColorMode;
    }

    public void setDisplaySize(int cellSize) {
        this.halfStarSize = (int)((double)cellSize * 0.15);
        super.setDisplaySize(cellSize);
    }

    public void drawBoard(Graphics2D g) {
        this.paintAreas(g);
        this.drawGrid(g);
        if (!this.isHideStarMode()) {
            this.drawStars(g);
        }
        if (this.isShowAreaBorderMode()) {
            this.drawAreaBorders(g);
        }
        this.drawBoardBorder(g);
    }

    private void paintAreas(Graphics2D g) {
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                if (this.board.isCovered(r, c) && this.board.getArea(r, c) != this.draggingArea) {
                    int starType = this.board.getArea(r, c).getStarType();
                    g.setColor(this.whiteAreaColor);
                    if (this.isSeparateAreaColorMode()) {
                        if (starType == -1) {
                            g.setColor(this.getErrorColor());
                        } else if (starType == 1) {
                            g.setColor(this.whiteAreaColor);
                        } else if (starType == 2) {
                            g.setColor(this.blackAreaColor);
                        } else {
                            g.setColor(this.noStarAreaColor);
                        }
                    }
                    if (this.isIndicateErrorMode()) {
                        if (starType == -1) {
                            g.setColor(this.getErrorColor());
                        } else if (starType == 0) {
                            g.setColor(this.noStarAreaColor);
                        } else if (!this.board.getArea(r, c).isPointSymmetry()) {
                            g.setColor(this.getErrorColor());
                        }
                    }
                    this.paintCell(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawStars(Graphics2D g) {
        int r = 0;
        while (r < this.board.rows() * 2 - 1) {
            int c = 0;
            while (c < this.board.cols() * 2 - 1) {
                if (this.board.hasStar(r, c)) {
                    this.placeStar(g, r, c, this.board.getStar(r, c));
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawAreaBorders(Graphics2D g) {
        int c;
        g.setColor(this.areaBorderColor);
        int r = 0;
        while (r < this.board.rows()) {
            c = 0;
            while (c < this.board.cols() - 1) {
                if (this.board.getArea(r, c) != this.board.getArea(r, c + 1)) {
                    this.placeSideLine(g, 0, r, c);
                }
                ++c;
            }
            ++r;
        }
        r = 0;
        while (r < this.board.rows() - 1) {
            c = 0;
            while (c < this.board.cols()) {
                if (this.board.getArea(r, c) != this.board.getArea(r + 1, c)) {
                    this.placeSideLine(g, 1, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    public void placeStar(Graphics2D g, int r, int c, int star) {
        if (star == 1) {
            if (this.isSeparateAreaColorMode()) {
                g.setColor(this.getWhiteAreaColor());
            } else {
                g.setColor(this.getBackgroundColor());
            }
        } else if (star == 2) {
            if (this.isSeparateAreaColorMode()) {
                g.setColor(this.getBlackAreaColor());
            } else {
                g.setColor(this.starColor);
            }
        }
        this.fillCircle(g, this.getOffsetx() + this.getCellSize() * (c + 1) / 2, this.getOffsety() + this.getCellSize() * (r + 1) / 2, this.getHalfStarSize());
        g.setColor(this.starColor);
        this.drawCircle(g, this.getOffsetx() + this.getCellSize() * (c + 1) / 2, this.getOffsety() + this.getCellSize() * (r + 1) / 2, this.getHalfStarSize());
    }

    public void drawCursor(Graphics2D g) {
        if (this.isProblemEditMode()) {
            g.setColor(this.getCursorColor());
            g.drawRect(this.getOffsetx() + (this.getCellSize() * this.getCellCursor().c() + this.getHalfCellSize()) / 2, this.getOffsety() + (this.getCellSize() * this.getCellCursor().r() + this.getHalfCellSize()) / 2, this.getHalfCellSize(), this.getHalfCellSize());
        }
    }
}

