/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.tentaisho;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.tentaisho.Panel;

public class Menu
extends MenuBase {
    private JMenuItem areaBorderColorItem;
    private JMenuItem whiteAreaColorItem;
    private JMenuItem blackAreaColorItem;
    private JMenuItem hideStarItem;
    private JMenuItem showAreaBorderItem;
    private JMenuItem indicateErrorItem;
    private JMenuItem separateAreaColorItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    protected void buildEditMenu() {
        super.buildEditMenu();
    }

    protected void buildViewMenu() {
        super.buildViewMenu();
        this.areaBorderColorItem = this.addColorMenuItem("\u9818\u57df\u5883\u754c");
        this.whiteAreaColorItem = this.addColorMenuItem("\u767d\u661f\u9818\u57df");
        this.blackAreaColorItem = this.addColorMenuItem("\u9ed2\u661f\u9818\u57df");
        this.hideStarItem = this.makeCheckBoxCommandMenuItem("\u661f\u306e\u975e\u8868\u793a(H)", 'H', false);
        this.addToViewMenu(this.hideStarItem);
        this.showAreaBorderItem = this.makeCheckBoxCommandMenuItem("\u5883\u754c\u7dda\u8868\u793a(B)", 'B', true);
        this.addToViewMenu(this.showAreaBorderItem);
        this.indicateErrorItem = this.makeCheckBoxCommandMenuItem("\u6b63\u8aa4\u3092\u8272\u3067\u793a\u3059(E)", 'E', false);
        this.addToViewMenu(this.indicateErrorItem);
        this.separateAreaColorItem = this.makeCheckBoxCommandMenuItem("\u9818\u57df\u306e\u8272\u5206\u3051(R)", 'R', false);
        this.addToViewMenu(this.separateAreaColorItem);
    }

    public void executeCommand2(JMenuItem target) {
        if (target == this.indicateErrorItem) {
            this.getPanel().setIndicateErrorMode(target.isSelected());
        } else if (target == this.showAreaBorderItem) {
            this.getPanel().setShowAreaBorderMode(target.isSelected());
        } else if (target == this.separateAreaColorItem) {
            this.getPanel().setSeparateAreaColorMode(target.isSelected());
        } else if (target == this.hideStarItem) {
            this.getPanel().setHideStarMode(target.isSelected());
        }
    }

    public Color getColor(JMenuItem target) {
        if (target == this.areaBorderColorItem) {
            return this.getPanel().getAreaBorderColor();
        }
        if (target == this.whiteAreaColorItem) {
            return this.getPanel().getWhiteAreaColor();
        }
        if (target == this.blackAreaColorItem) {
            return this.getPanel().getBlackAreaColor();
        }
        return super.getColor(target);
    }

    public void setColor(JMenuItem target, Color color) {
        if (target == this.areaBorderColorItem) {
            this.getPanel().setAreaBorderColor(color);
        } else if (target == this.whiteAreaColorItem) {
            this.getPanel().setWhiteAreaColor(color);
        } else if (target == this.blackAreaColorItem) {
            this.getPanel().setBlackAreaColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.hideStarItem.setSelected(this.getPanel().isHideStarMode());
        this.showAreaBorderItem.setSelected(this.getPanel().isShowAreaBorderMode());
        this.separateAreaColorItem.setSelected(this.getPanel().isSeparateAreaColorMode());
        this.indicateErrorItem.setSelected(this.getPanel().isIndicateErrorMode());
    }
}

