/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.tentaisho;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.tentaisho.Area;
import pencilbox.tentaisho.StarAddress;
import pencilbox.util.ArrayUtil;

public class Board
extends BoardBase {
    static final int NOSTAR = 0;
    static final int WHITESTAR = 1;
    static final int BLACKSTAR = 2;
    private int[][] star;
    private Area[][] area;
    private List areaList;

    protected void setup() {
        super.setup();
        this.star = new int[this.rows() * 2 - 1][this.cols() * 2 - 1];
        this.area = new Area[this.rows()][this.cols()];
        this.areaList = new LinkedList();
    }

    public void clearBoard() {
        super.clearBoard();
        this.areaList.clear();
        ArrayUtil.initArrayObject2(this.area, null);
    }

    public void initBoard() {
        this.initAreas();
    }

    public void initAreas() {
        Iterator itr = this.areaList.iterator();
        while (itr.hasNext()) {
            this.initArea((Area)itr.next());
        }
    }

    public int nStar() {
        int nStar = 0;
        int r = 0;
        while (r < this.rows() * 2 - 1) {
            int c = 0;
            while (c < this.cols() * 2 - 1) {
                if (this.hasStar(r, c)) {
                    ++nStar;
                }
                ++c;
            }
            ++r;
        }
        return nStar;
    }

    int[][] getStar() {
        return this.star;
    }

    public int getStar(int r, int c) {
        return this.star[r][c];
    }

    public void setStar(int r, int c, int st) {
        this.star[r][c] = st;
    }

    public boolean hasStar(int r, int c) {
        return this.star[r][c] > 0;
    }

    public boolean isOnStar(int r, int c) {
        return r >= 0 && r < this.rows() * 2 - 1 && c >= 0 && c < this.cols() * 2 - 1;
    }

    public boolean isCovered(int r, int c) {
        return this.area[r][c] != null;
    }

    public Area getArea(int r, int c) {
        return this.area[r][c];
    }

    public void setArea(int r, int c, Area a) {
        this.area[r][c] = a;
    }

    public void addArea(Area newArea) {
        Iterator itr = newArea.iterator();
        while (itr.hasNext()) {
            Address pos = (Address)itr.next();
            this.setArea(pos.r(), pos.c(), newArea);
        }
        this.areaList.add(newArea);
    }

    void addCellToAreaA(int r, int c, Area area) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(r, c, area, 1)));
        this.addCellToArea(r, c, area);
    }

    void removeCellFromAreaA(int r, int c, Area area) {
        this.fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(r, c, area, 0)));
        this.removeCellFromArea(r, c, area);
    }

    public void addCellToArea(int r, int c, Area area) {
        if (area.isEmpty()) {
            this.areaList.add(area);
        }
        this.setArea(r, c, area);
        area.add(r, c);
        this.initArea(area);
    }

    public void removeCellFromArea(int r, int c, Area area) {
        this.setArea(r, c, null);
        area.remove(r, c);
        if (area.isEmpty()) {
            this.areaList.remove(area);
        } else {
            this.initArea(area);
        }
    }

    void initArea(Area newArea) {
        int nStar = 0;
        StarAddress starPos = new StarAddress();
        Iterator itr = newArea.iterator();
        while (itr.hasNext()) {
            Address pos = (Address)itr.next();
            int i = 2 * pos.r() - 1;
            while (i <= 2 * pos.r() + 1) {
                int j = 2 * pos.c() - 1;
                while (j <= 2 * pos.c() + 1) {
                    if (this.isOnStar(i, j) && this.hasStar(i, j)) {
                        if (nStar == 0) {
                            nStar = this.getStar(i, j);
                            starPos.set(i, j);
                        } else if (!(nStar != 1 && nStar != 2 || starPos.equals(i, j))) {
                            nStar = -1;
                            starPos.setNowhere();
                        }
                    }
                    ++j;
                }
                ++i;
            }
        }
        newArea.setStarType(nStar);
        newArea.setStarPos(starPos);
    }

    public int checkAnswerCode() {
        int result = 0;
        Iterator itr = this.areaList.iterator();
        while (itr.hasNext()) {
            Area a = (Area)itr.next();
            if (a.isPointSymmetry()) continue;
            result |= 1;
        }
        int r = 0;
        while (r < this.rows()) {
            int c = 0;
            while (c < this.cols()) {
                if (this.area[r][c] == null) {
                    result |= 2;
                }
                ++c;
            }
            ++r;
        }
        return result;
    }

    public String checkAnswerString() {
        int result = this.checkAnswerCode();
        if (result == 0) {
            return "\u6b63\u89e3\u3067\u3059";
        }
        StringBuffer message = new StringBuffer();
        if ((result & 1) == 1) {
            message.append("\u6b63\u3057\u304f\u306a\u3044\u9818\u57df\u304c\u3042\u308b\n");
        } else if ((result & 2) == 2) {
            message.append("\u672a\u5b8c\u6210\n");
        }
        return message.toString();
    }

    List getAreaList() {
        return this.areaList;
    }

    Area[][] getArea() {
        return this.area;
    }

    class Step
    extends AbstractUndoableEdit {
        static final int ADDED = 1;
        static final int REMOVED = 0;
        static final int CHANGED = 2;
        private int r;
        private int c;
        private Area area;
        private int operation;

        public Step(int r, int c, Area area, int operation) {
            this.r = r;
            this.c = c;
            this.area = area;
            this.operation = operation;
        }

        public void undo() throws CannotUndoException {
            super.undo();
            if (this.operation == 1) {
                Board.this.removeCellFromArea(this.r, this.c, this.area);
            } else if (this.operation == 0) {
                Board.this.addCellToArea(this.r, this.c, this.area);
            }
        }

        public void redo() throws CannotRedoException {
            super.redo();
            if (this.operation == 1) {
                Board.this.addCellToArea(this.r, this.c, this.area);
            } else if (this.operation == 0) {
                Board.this.removeCellFromArea(this.r, this.c, this.area);
            }
        }
    }
}

