/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hakyukoka;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.HintDot;
import pencilbox.common.gui.PanelBase;
import pencilbox.hakyukoka.Area;
import pencilbox.hakyukoka.Board;

public class Panel
extends PanelBase {
    private Board board;
    private boolean indicateErrorMode = false;
    private boolean highlightSelectionMode = false;
    private Color inputColor = Color.BLUE;
    private Color areaBorderColor = Color.BLACK;
    private Color noAreaColor = new Color(0xC0C0C0);
    private int selectedNumber = 0;
    private Color highlightColor = new Color(65280);
    private Color beamColor = new Color(0x800000);
    private Area draggingArea;
    private boolean dotHintMode = false;
    private HintDot hintDot = new HintDot();

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setCursorMode(true);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
        this.hintDot.setDot(this, 3, this.getCellSize());
    }

    public int getSelectedNumber() {
        return this.selectedNumber;
    }

    public void setSelectedNumber(int selectedNumber) {
        this.selectedNumber = selectedNumber;
    }

    Area getDraggingArea() {
        return this.draggingArea;
    }

    void setDraggingArea(Area draggingArea) {
        this.draggingArea = draggingArea;
    }

    public Color getInputColor() {
        return this.inputColor;
    }

    public void setInputColor(Color inputColor) {
        this.inputColor = inputColor;
    }

    public void setAreaBorderColor(Color areaBorderColor) {
        this.areaBorderColor = areaBorderColor;
    }

    public Color getAreaBorderColor() {
        return this.areaBorderColor;
    }

    public boolean isHighlightSelectionMode() {
        return this.highlightSelectionMode;
    }

    public void setHighlightSelectionMode(boolean highlightSelectionMode) {
        this.highlightSelectionMode = highlightSelectionMode;
    }

    public boolean isDotHintMode() {
        return this.dotHintMode;
    }

    public void setDotHintMode(boolean dotHintMode) {
        this.dotHintMode = dotHintMode;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public void setDisplaySize(int cellSize) {
        super.setDisplaySize(cellSize);
        this.hintDot.setDotSize(cellSize);
    }

    public void drawBoard(Graphics2D g) {
        this.paintCells(g);
        this.drawBeams(g);
        this.drawNumbers(g);
        this.drawGrid(g);
        this.drawAreaBorders(g);
        this.drawBoardBorder(g);
    }

    private void drawBeams(Graphics2D g) {
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int n = this.board.getNumber(r, c);
                if (this.isHighlightSelectionMode() && n > 0 && n == this.getSelectedNumber()) {
                    int cc = c - n;
                    while (cc <= c + n) {
                        if (cc != c && this.board.isOn(r, cc)) {
                            g.setColor(this.beamColor);
                            this.placeCenterLine(g, r, cc, 1);
                        }
                        ++cc;
                    }
                    int rr = r - n;
                    while (rr <= r + n) {
                        if (rr != r && this.board.isOn(rr, c)) {
                            g.setColor(this.beamColor);
                            this.placeCenterLine(g, rr, c, 0);
                        }
                        ++rr;
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    private void paintCells(Graphics2D g) {
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                if (this.board.getArea(r, c) == null || this.board.getArea(r, c) == this.draggingArea) {
                    g.setColor(this.noAreaColor);
                    this.paintCell(g, r, c);
                }
                if (this.isHighlightSelectionMode() && this.getSelectedNumber() > 0 && this.board.getNumber(r, c) == this.getSelectedNumber()) {
                    g.setColor(this.highlightColor);
                    this.paintCell(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawNumbers(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int n = this.board.getNumber(r, c);
                if (n > 0) {
                    if (this.board.isStable(r, c)) {
                        g.setColor(this.getNumberColor());
                    } else {
                        g.setColor(this.getInputColor());
                        if (this.isIndicateErrorMode() && this.board.isError(r, c)) {
                            g.setColor(this.getErrorColor());
                        }
                    }
                    this.placeNumber(g, r, c, n);
                } else if (n == 0) {
                    if (this.isDotHintMode()) {
                        this.placeHintDot(g, r, c);
                    }
                    if (this.board.isStable(r, c)) {
                        g.setColor(this.getNumberColor());
                        this.placeBoldCircle(g, r, c);
                    }
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawAreaBorders(Graphics2D g) {
        g.setColor(this.getAreaBorderColor());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols() - 1) {
                if (this.board.getArea(r, c) != this.board.getArea(r, c + 1)) {
                    this.placeSideLine(g, 0, r, c);
                }
                ++c;
            }
            if (this.board.getArea(r, 0) != null) {
                this.placeSideLine(g, 0, r, -1);
            }
            if (this.board.getArea(r, this.board.cols() - 1) != null) {
                this.placeSideLine(g, 0, r, this.board.cols() - 1);
            }
            ++r;
        }
        int c = 0;
        while (c < this.board.cols()) {
            int r2 = 0;
            while (r2 < this.board.rows() - 1) {
                if (this.board.getArea(r2, c) != this.board.getArea(r2 + 1, c)) {
                    this.placeSideLine(g, 1, r2, c);
                }
                ++r2;
            }
            if (this.board.getArea(0, c) != null) {
                this.placeSideLine(g, 1, -1, c);
            }
            if (this.board.getArea(this.board.rows() - 1, c) != null) {
                this.placeSideLine(g, 1, this.board.rows() - 1, c);
            }
            ++c;
        }
    }

    private void placeHintDot(Graphics2D g, int r, int c) {
        int pat = this.board.getPattern(r, c);
        if (pat == 0) {
            this.hintDot.placeHintCross(g, r, c);
        } else {
            this.hintDot.placeHintDot(g, r, c, pat);
        }
    }
}

