/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.numberlink;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelEventHandlerBase;
import pencilbox.numberlink.Board;
import pencilbox.numberlink.Link;
import pencilbox.numberlink.Panel;

public class PanelEventHandler
extends PanelEventHandlerBase {
    private Board board;

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    protected void leftDragged(Address dragStart, Address dragEnd) {
        if (dragStart.r() == dragEnd.r() || dragStart.c() == dragEnd.c()) {
            this.board.determineInlineState(dragStart, dragEnd, 1);
        }
    }

    protected void rightDragged(Address dragStart, Address dragEnd) {
        if (dragStart.r() == dragEnd.r() || dragStart.c() == dragEnd.c()) {
            this.board.determineInlineState(dragStart, dragEnd, 0);
        }
    }

    protected void leftClicked(Address pos) {
        Link link = this.board.getLink(pos.r(), pos.c());
        int newNumber = 0;
        if (this.board.isNumber(pos.r(), pos.c())) {
            newNumber = this.board.getNumber(pos.r(), pos.c());
        } else if (link != null) {
            newNumber = link.getNumber();
        }
        if (newNumber == this.getSelectedNumber() && this.getSelectedLink() == link) {
            this.setSelectedLink(null);
            this.setSelectedNumber(0);
        } else {
            this.setSelectedLink(link);
            this.setSelectedNumber(newNumber);
        }
    }

    protected void numberEntered(Address pos, int num) {
        if (this.isProblemEditMode() && num > 0) {
            Address posS;
            this.board.setNumber(pos.r(), pos.c(), num);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setNumber(posS.r(), posS.c(), -1);
            }
        }
    }

    protected void spaceEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos.r(), pos.c(), 0);
            if (this.isSymmetricPlacementMode() && this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setNumber(posS.r(), posS.c(), 0);
            }
        }
    }

    protected void minusEntered(Address pos) {
        if (this.isProblemEditMode()) {
            Address posS;
            this.board.setNumber(pos.r(), pos.c(), -1);
            if (this.isSymmetricPlacementMode() && !this.board.isNumber((posS = this.getSymmetricPosition(pos)).r(), posS.c())) {
                this.board.setNumber(posS.r(), posS.c(), -1);
            }
        }
    }

    private Link getSelectedLink() {
        return ((Panel)this.getPanel()).getSelectedLink();
    }

    private void setSelectedLink(Link l) {
        ((Panel)this.getPanel()).setSelectedLink(l);
    }

    private int getSelectedNumber() {
        return ((Panel)this.getPanel()).getSelectedNumber();
    }

    private void setSelectedNumber(int n) {
        ((Panel)this.getPanel()).setSelectedNumber(n);
    }
}

