/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.numberlink;

import java.awt.Color;
import javax.swing.JMenuItem;
import pencilbox.common.gui.MenuBase;
import pencilbox.numberlink.Panel;

public class Menu
extends MenuBase {
    private JMenuItem numberColorItem;
    private JMenuItem lineColorItem;
    private JMenuItem separateLinkColorItem;
    private JMenuItem highlightSelectionItem;

    public Panel getPanel() {
        return (Panel)this.getPanelBase();
    }

    protected void buildEditMenu() {
        this.addSymmetricPlacementMenuItem();
        super.buildEditMenu();
    }

    protected void buildViewMenu() {
        super.buildViewMenu();
        this.numberColorItem = this.addColorMenuItem("\u6570\u5b57");
        this.lineColorItem = this.addColorMenuItem("\u7dda");
        this.separateLinkColorItem = this.makeCheckBoxCommandMenuItem("\u7dda\u306e\u8272\u5206\u3051(R)", 'R', false);
        this.addToViewMenu(this.separateLinkColorItem);
        this.highlightSelectionItem = this.makeCheckBoxCommandMenuItem("\u9078\u629e\u6570\u5b57\u30cf\u30a4\u30e9\u30a4\u30c8(H)", 'H', false);
        this.addToViewMenu(this.highlightSelectionItem);
        this.addRenewColorMenuItem();
    }

    public void executeCommand2(JMenuItem target) {
        if (target == this.separateLinkColorItem) {
            this.getPanel().setSeparateLinkColorMode(target.isSelected());
        } else if (target == this.highlightSelectionItem) {
            this.getPanel().setHighlightSelectionMode(target.isSelected());
        }
    }

    public Color getColor(JMenuItem target) {
        if (target == this.lineColorItem) {
            return this.getPanel().getLineColor();
        }
        if (target == this.numberColorItem) {
            return this.getPanel().getNumberColor();
        }
        return super.getColor(target);
    }

    public void setColor(JMenuItem target, Color color) {
        if (target == this.lineColorItem) {
            this.getPanel().setLineColor(color);
        } else if (target == this.numberColorItem) {
            this.getPanel().setNumberColor(color);
        } else {
            super.setColor(target, color);
        }
    }

    public void updateCurrentMenuSelection() {
        super.updateCurrentMenuSelection();
        this.separateLinkColorItem.setSelected(this.getPanel().isSeparateLinkColorMode());
        this.highlightSelectionItem.setSelected(this.getPanel().isHighlightSelectionMode());
    }
}

