/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.kurodoko;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.kurodoko.Board;

public class Panel
extends PanelBase {
    private Board board;
    private boolean indicateErrorMode = false;
    private Color paintColor = Color.BLUE;
    private Color circleColor = Color.MAGENTA;

    public Panel() {
        this.setGridColor(Color.BLACK);
        this.setMarkStyle(1);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setPaintColor(Color paintColor) {
        this.paintColor = paintColor;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public void drawBoard(Graphics2D g) {
        this.drawCells(g);
        this.drawGrid(g);
        this.drawBoardBorder(g);
    }

    private void drawCells(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int st = this.board.getState(r, c);
                if (st == -2) {
                    this.paintCell1(g, r, c);
                } else if (st == -1) {
                    g.setColor(this.getCircleColor());
                    this.placeMark(g, r, c);
                } else if (st > 0 || st == Board.UNDECIDED_NUMBER) {
                    this.placeNumber1(g, r, c, st);
                }
                ++c;
            }
            ++r;
        }
    }

    private void paintCell1(Graphics2D g, int r, int c) {
        g.setColor(this.getPaintColor());
        if (this.isIndicateErrorMode() && (this.board.isBlock(r, c) || this.board.getChain(r, c) < 0)) {
            g.setColor(this.getErrorColor());
        }
        this.paintCell(g, r, c);
    }

    private void placeNumber1(Graphics2D g, int r, int c, int num) {
        if (this.getMarkStyle() == 5) {
            g.setColor(this.getCircleColor());
            this.paintCell(g, r, c);
        }
        g.setColor(this.getNumberColor());
        this.placeCircle(g, r, c, this.getCellSize() - 2);
        if (num > 0) {
            int nSpace;
            if (this.isIndicateErrorMode() && (nSpace = this.board.getSumSpace(r, c)) != num) {
                g.setColor(this.getErrorColor());
            }
            this.placeNumber(g, r, c, num);
        }
    }
}

