/*
 * Decompiled with CFR 0.152.
 */
package pencilbox.hitori;

import java.awt.Color;
import java.awt.Graphics2D;
import pencilbox.common.core.BoardBase;
import pencilbox.common.gui.PanelBase;
import pencilbox.hitori.Board;

public class Panel
extends PanelBase {
    private Board board;
    private Color paintColor = Color.BLUE;
    private Color circleColor = Color.MAGENTA;
    private Color soleNumberColor = new Color(0xC0C0C0);
    private boolean hideSoleNumberMode = false;
    private boolean indicateErrorMode = false;
    private char[] letters = new char[0];

    public Panel() {
        this.setMarkStyle(1);
    }

    protected void setBoard(BoardBase aBoard) {
        this.board = (Board)aBoard;
    }

    public Color getCircleColor() {
        return this.circleColor;
    }

    public void setCircleColor(Color circleColor) {
        this.circleColor = circleColor;
    }

    public Color getPaintColor() {
        return this.paintColor;
    }

    public void setPaintColor(Color paintColor) {
        this.paintColor = paintColor;
    }

    public boolean isIndicateErrorMode() {
        return this.indicateErrorMode;
    }

    public void setIndicateErrorMode(boolean indicateErrorMode) {
        this.indicateErrorMode = indicateErrorMode;
    }

    public boolean isHideSoleNumberMode() {
        return this.hideSoleNumberMode;
    }

    public void setHideSoleNumberMode(boolean hideSoleNumberMode) {
        this.hideSoleNumberMode = hideSoleNumberMode;
    }

    String getLetters() {
        return new String(this.letters);
    }

    void setLetters(String string) {
        this.letters = string.toCharArray();
    }

    public void drawBoard(Graphics2D g) {
        this.drawCells(g);
        this.drawGrid(g);
        this.drawBoardBorder(g);
    }

    private void drawCells(Graphics2D g) {
        g.setFont(this.getNumberFont());
        int r = 0;
        while (r < this.board.rows()) {
            int c = 0;
            while (c < this.board.cols()) {
                int state = this.board.getState(r, c);
                this.drawState(g, r, c, state);
                int number = this.board.getNumber(r, c);
                if (number > 0) {
                    this.drawNumber1(g, r, c, number);
                } else if (number == -1) {
                    this.placeBoldCircle(g, r, c);
                }
                ++c;
            }
            ++r;
        }
    }

    private void drawState(Graphics2D g, int r, int c, int state) {
        if (state == -2) {
            g.setColor(this.getPaintColor());
            if (this.isIndicateErrorMode()) {
                if (this.board.getChain(r, c) == -1) {
                    g.setColor(this.getErrorColor());
                }
                if (this.board.isBlock(r, c)) {
                    g.setColor(this.getErrorColor());
                }
            }
            this.paintCell(g, r, c);
        } else if (state == -1) {
            g.setColor(this.getCircleColor());
            this.placeMark(g, r, c);
        }
    }

    private void drawNumber1(Graphics2D g, int r, int c, int number) {
        g.setColor(this.getNumberColor());
        if (this.isHideSoleNumberMode() && this.board.isSingle(r, c)) {
            g.setColor(this.soleNumberColor);
        }
        if (this.isIndicateErrorMode() && !this.board.isBlack(r, c) && this.board.isRedundantNumber(r, c)) {
            g.setColor(this.getErrorColor());
        }
        if (number <= this.letters.length) {
            this.placeLetter(g, r, c, this.letters[number - 1]);
        } else {
            this.placeNumber(g, r, c, number);
        }
    }
}

