package pencilbox.shikaku;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

import javax.swing.event.UndoableEditEvent;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;

import pencilbox.common.core.Address;
import pencilbox.common.core.BoardBase;
import pencilbox.util.ArrayUtil;


/**
 * ulpɐ؂vՖʃNX
 */
public class Board extends BoardBase {
	
	static final int UNDECIDED_NUMBER = -1;
	
	private int[][] number;
	private Square[][] square;
	private List squareList;

	protected void setup() {
		super.setup();
		number = new int[rows()][cols()];
		square = new Square[rows()][cols()];
		squareList = new LinkedList();
	}

	public void clearBoard() {
		super.clearBoard();
		squareList.clear();
		ArrayUtil.initArrayObject2(square, null);
	}

	/**
	 * @return the number
	 */
	int[][] getNumber() {
		return number;
	}

	public void initBoard() {
		initSquares();
	}

	/**
	 * Ֆʏ̗̈̏s
	 */
	public void initSquares() {
		for (Iterator itr = squareList.iterator(); itr.hasNext(); ) {
			initSquare1((Square)itr.next());
		}
	}
	/**
	 * lpɐݒ肵C}XɎlpݒ肷
	 * @param a ǉlp
	 */
	public void initSquare1(Square a) {
		int n = 0;
		for (int r = a.r0; r <= a.r1; r++ ) {
			for (int c = a.c0; c <= a.c1; c++) {
				if (isNumber(r,c)) {
					if (n != 0)
						n = Square.MULTIPLE_NUMBER;
					else
						n = number[r][c];
				}
				square[r][c] = a;
			}
		}
		a.setNumber(n);
	}

	/**
	 * @return Returns the squareList.
	 */
	List getSquareList() {
		return squareList;
	}

	/**
	 * }X̐擾
	 * @param r sW
	 * @param c W
	 * @return }X̐
	 */
	public int getNumber(int r, int c) {
		return number[r][c];
	}
	/**
	 * }Xɐݒ肷
	 * @param r sW
	 * @param c W
	 * @param n ݒ肷鐔
	 */
	public void setNumber(int r, int c, int n) {
		number[r][c] = n;
	}
	/**
	 * ̃}Xɐ邩
	 * @param r sW
	 * @param c W
	 * @return@̃}Xɐ true
	 */
	public boolean isNumber(int r, int c) {
		return number[r][c] > 0 || number[r][c] == UNDECIDED_NUMBER;
	}
	/**
	 * ̃}X̑ Square Ԃ
	 * @param r sW
	 * @param c W
	 * @return@̃}X̑ Square
	 */
	public Square getSquare(int r, int c) {
		return square[r][c];
	}
	/**
	 * ̈惊XgIterator擾
	 * @return ̈惊XgIterator
	 */
	public Iterator getSquareListIterator() {
		return squareList.iterator();
	}
	/**
	 * ̈惊Xg̃TCYC܂̈搔擾
	 * @return ̈惊Xg̃TCY
	 */
	public int getSquareListSize() {
		return squareList.size();
	}
	
	/**
	 * ̃}Xꂩ̎lpɊ܂܂Ă邩ǂ
	 * @param r sW
	 * @param c W
	 * @return ܂܂Ă true
	 */
	public boolean isCovered(int r, int c) {
		return square[r][c] != null;
	}

	/**
	 * ɗ^ꂽ2̍WΊpʒuƂlpǉ
	 * ̍ۂɁCǉlpƏdȂʒuɑ̎lpłɂC̎lp
	 * @param pos0 ̊p̍W
	 * @param pos1 ̊p̍W
	 */
	public void addSquareSpanning(Address pos0, Address pos1) {
		int ra = pos0.r()<pos1.r() ? pos0.r() : pos1.r();
		int rb = pos0.r()<pos1.r() ? pos1.r() : pos0.r();
		int ca = pos0.c()<pos1.c() ? pos0.c() : pos1.c();
		int cb = pos0.c()<pos1.c() ? pos1.c() : pos0.c();
		Square newArea = new Square(ra, ca, rb, cb);
		for (int r = ra; r <= rb; r++ ) {
			for (int c = ca; c <= cb; c++) {
				if(getSquare(r,c) != null) {
					removeSquareA(getSquare(r,c));
				}
			}
		}
		addSquareA(newArea);
	}
	/**
	 * ɗ^ꂽ}X܂ގlp
	 * @param pos W 
	 */
	public void removeSquareIncluding(Address pos) {
		if(getSquare(pos.r(),pos.c()) != null) {
			removeSquareA(getSquare(pos.r(),pos.c()));
		}
	}
	/**
	 * lpǉ
	 * AhDXi[ɒʒm
	 * @param aq ǉlp
	 */
	public void addSquareA(Square aq){
		fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(aq,Step.ADDED)));
		addSquare(aq);
	}
	/**
	 * lp
	 * AhDXi[ɒʒm
	 * @param a lp
	 */
	public void removeSquareA(Square a){
		fireUndoableEditUpdate(new UndoableEditEvent(this, new Step(a,Step.REMOVED)));
		removeSquare(a);
	}
	
	/**
	 * lpǉ
	 * @param sq ǉlp
	 */
	public void addSquare(Square sq) {
		initSquare1(sq);
		squareList.add(sq);
	}
	/**
	 * lp
	 * @param sq lp
	 */
	public void removeSquare(Square sq) {
		for (int r = sq.r0; r <= sq.r1; r++ ) {
			for (int c = sq.c0; c <= sq.c1; c++) {
				square[r][c] = null;
			}
		}
		squareList.remove(sq);
	}

	public int checkAnswerCode() {
		int errorCode = 0;
		Square a;
		int nNumber = 0;
		for (Iterator itr = squareList.iterator(); itr.hasNext(); ) {
			a = (Square)itr.next();
			int n = a.getNumber();
			if (n == Square.MULTIPLE_NUMBER) {
				errorCode |= 1; 
			} else if (n == Square.NO_NUMBER) {
				errorCode |= 2; 
			} else if (n == UNDECIDED_NUMBER) {
				;
			} else if (n < a.getSquareSize()) {
				errorCode |= 4; 
			} else if (n > a.getSquareSize()) {
				errorCode |= 8; 
			}
		}
		for (int r=0; r<rows(); r++) {
			for (int c=0; c<cols(); c++) {
				if (isNumber(r,c))
					nNumber ++;
					if(square[r][c] == null)
						errorCode |= 16; 
			}
		}
		if (nNumber==0)
			errorCode = 32; 
		return errorCode;
	}

	public String checkAnswerString() {
		int result = checkAnswerCode();
		if (result == 0)
			return COMPLETE_MESSAGE;
		if (result == 32)
			return "ՏɐЂƂȂ\n";
		StringBuffer message = new StringBuffer();
		if ((result & 1) == 1)
			message.append("̐܂ގlp\n");
		if ((result & 2) == 2)
			message.append("܂܂Ȃlp\n");
		if ((result & 4) == 4)
			message.append("ʐς𒴂lp\n");
		if ((result & 8) == 8)
			message.append("ʐςɖȂlp\n");
		if ((result & 16) == 16)
			message.append("lpɊ܂܂Ȃ}X\n");
		return message.toString();
	}
	
	/**
	 * P̑\NX
	 * UNDO, REDO ł̕ҏW̒PʂƂȂ
	 */
	class Step extends AbstractUndoableEdit {
		
		static final int ADDED = 1;
		static final int REMOVED = 0;
		
		private Square square;
		private int operation;

		/**
		 * RXgN^
		 * @param sq ꂽ̈
		 * @param operation ̎ށFǉꂽ̂Cꂽ̂
		 */
		public Step(Square sq, int operation) {
			super();
			this.square = sq;
			this.operation = operation;
		}
		
		public void undo() throws CannotUndoException {
			super.undo();
			if (operation==ADDED) {
				removeSquare(square);
			} else if (operation==REMOVED){
				addSquare(square);
			}
		}

		public void redo() throws CannotRedoException {
			super.redo();
			if (operation==ADDED) {
				addSquare(square);
			} else if (operation==REMOVED){
				removeSquare(square);
			}
		}
	}

}