package pencilbox.bijutsukan;

import java.awt.Color;

import javax.swing.JMenuItem;

import pencilbox.common.gui.MenuBase;

/**
 * upفvj[NX
 */
public class Menu extends MenuBase {

	private JMenuItem bulbColorItem;
	private JMenuItem noBulbColorItem;
	private JMenuItem lluminatedCellColorItem;
	private JMenuItem warnWrongBulbItem;
	private JMenuItem paintIlluminatedCellModeItem;
	private JMenuItem showBeamItem;

	public Panel getPanel() {
		return (Panel) getPanelBase();
	}

	protected void buildIndividualMenu(){
		bulbColorItem = addColorMenuItem("Ɩ");
		noBulbColorItem = addColorMenuItem("ƖȂ");
		lluminatedCellColorItem = addColorMenuItem("Ƃ炳ꂽ}X");
		addToViewMenu(warnWrongBulbItem = makeCheckBoxCommandMenuItem("Ԃŕ\(W)", 'W', false));
		addToViewMenu(paintIlluminatedCellModeItem = makeCheckBoxCommandMenuItem("Ƃ炳ꂽ}Xh(P)", 'P', true));
		addToViewMenu(showBeamItem = makeCheckBoxCommandMenuItem("\(B)", 'B', false));
		addSymmetricPlacementMenuItem();
		addTrimAnswerMenuItem();
		buildMarkStyleMenu("ƖȂ̈(N)", 'N', new int[] {3, 4});
	}

	public void executeCommand2(JMenuItem target) {
		if (target == warnWrongBulbItem) {
			getPanel().setWarnWrongBulb(target.isSelected());
		} else if (target == paintIlluminatedCellModeItem) {
			getPanel().setPaintIlluminatedCellMode(target.isSelected());
		} else if (target == showBeamItem) {
			getPanel().setShowBeamMode(target.isSelected());
		}
	}

	public Color getColor(JMenuItem target) {
		if (target == bulbColorItem)
			return getPanel().getBulbColor();
		else if (target == noBulbColorItem)
			return getPanel().getNoBulbColor();
		else if (target == lluminatedCellColorItem)
			return getPanel().getIlluminatedCellColor();
		return null;
	}

	public void setColor(JMenuItem target, Color color) {
		if (target == bulbColorItem)
			getPanel().setBulbColor(color);
		else if (target == noBulbColorItem)
			getPanel().setNoBulbColor(color);
		else if (target == lluminatedCellColorItem)
			getPanel().setIlluminatedCellColor(color);
	}
	
	public void updateCurrentMenuSelection() {
		super.updateCurrentMenuSelection();
		warnWrongBulbItem.setSelected(getPanel().isWarnWrongBulb());
		paintIlluminatedCellModeItem.setSelected(getPanel().isPaintIlluminatedCellMode());
		showBeamItem.setSelected(getPanel().isShowBeamMode());
	}

}

