package pencilbox.common.factory;

import java.io.File;

import pencilbox.common.core.BoardBase;
import pencilbox.common.core.PencilBoxException;
import pencilbox.common.core.Problem;
import pencilbox.common.core.Size;
import pencilbox.common.gui.Frame;
import pencilbox.common.gui.MenuBase;
import pencilbox.common.gui.MenuCommand;
import pencilbox.common.gui.PanelEventHandler;
import pencilbox.common.io.IOController;


/**
 * PencilBox t@Ng[NX
 */
public class PencilFactory {
	
	private PencilType pencilType;
	
	/**
	 * @param pencilType
	 */
	public PencilFactory(PencilType pencilType) {
		this.pencilType = pencilType;
	}
	/**
	 * PencilPuzzleCX^X쐬Ď擾
	 * @param pencilType 
	 * @return VPencilPuzzleCX^X
	 */
	public static PencilFactory getInstance(PencilType pencilType) {
		return new PencilFactory(pencilType);
	}
	
	/**
	 * ftHgTCYŃAvP[Vt[B
	 * Launcher, Main gpB
	 * @throws PencilBoxException
	 */
	public void createNewFrame() throws PencilBoxClassException {
//		try {
//			PuzzleCommon puzzleCommon = (PuzzleCommon) ClassUtil.createInstance(pencilType , "Puzzle");
//			Size size = puzzleCommon.getDefaultSize();
			Size size = pencilType.getDefaultSize();
			createNewFrame(size);
//		} catch (PencilBoxException e) {
//			e.printStackTrace();
//		}
	}

	/**
	 * ՖʃTCY^ăAvP[Vt[B
	 * uVKvj[̂̋NŎgpB
	 * @param size
	 * @throws PencilBoxClassException
	 */
	public void createNewFrame(Size size) throws PencilBoxClassException {
//		try {
			BoardBase board = (BoardBase) ClassUtil.createInstance(pencilType, "Board");
			board.setSize(size);
			Problem problem = new Problem(board);	
			createNewFrame(problem);
//		} catch (PencilBoxException e) {
//			e.printStackTrace();
//		}
	}

	/**
	 * t@C^ăAvP[Vt[B
	 * uJvj[̋NŎgpB
	 * @param file
	 * @throws PencilBoxException
	 */
	public void createNewFrame(File file) throws PencilBoxException {
//		try {
			Problem problem = IOController.getInstance(pencilType).openFile(file);
			createNewFrame(problem);
//		} catch (PencilBoxException e) {
//			e.printStackTrace();
//		}
	}

	/**
	 * Problem ^ăAvP[Vt[B
	 * ̃NXōŏIIɍ쐬iKŎgpB
	 * @param problem
	 * @throws PencilBoxClassException
	 */
	public void createNewFrame(Problem problem) throws PencilBoxClassException {
//		try {
			MenuCommand command = new MenuCommand();
			Frame frame = new Frame();
			MenuBase menu = (MenuBase) ClassUtil.createInstance(pencilType, "Menu");
			PanelEventHandler panel = (PanelEventHandler) ClassUtil.createInstance(pencilType, "Panel");
			frame.setup(panel);
			menu.setup(command, frame, panel);
			command.setup(pencilType, frame, panel, problem);
			panel.setup(problem.getBoard());
			frame.resize();
			frame.centering();
			frame.setVisible(true);
//		} catch (PencilBoxException e) {
//			e.printStackTrace();
//		}
	}

	/**
	 * t@Cǂݍœt[ŊJB
	 * uĊJvj[̋NŎgpB
	 * @param file
	 * @throws PencilBoxException
	 */
	public void createNewBoard(MenuCommand command, File file) throws PencilBoxException {
//		try {
			Problem problem = IOController.getInstance(pencilType).openFile(file);
			createNewBoard(command, problem);
//		} catch (PencilBoxException e) {
//			e.printStackTrace();
//		}
	}

	/**
	 * Problem ^ēt[ŊJB
	 * @param problem
	 * @throws PencilBoxClassException
	 */
	public void createNewBoard(MenuCommand command, Problem problem) throws PencilBoxClassException {
//		try {
//			MenuCommand command = new MenuCommand();
//			MenuBase menu = (MenuBase) ClassUtil.createInstance(pencilType, "Menu");
			PanelEventHandler panel = command.getPanelBase();
			Frame frame = command.getFrame();
//			frame.setup(panel);
//			menu.setup(command, frame, panel);
			command.setup(pencilType, problem);
			panel.setup(problem.getBoard());
			frame.resize();
//			frame.centering();
//			frame.setVisible(true);
//		} catch (PencilBoxException e) {
//			e.printStackTrace();
//		}
	}

}
