/*
 * Common Library for TBAS Softwares
 * Language: Java
 *
 * All Rights Reserved.
 * (c) Copyright 2002 by Tsukuba Bunko.
 *
 * $Id: GenericListener.java,v 1.1 2003/08/31 08:20:49 ppoi Exp $
 */
package tsukuba_bunko.util;

import	java.lang.reflect.Method;
import	java.lang.reflect.InvocationHandler;
import	java.lang.reflect.InvocationTargetException;
import	java.lang.reflect.Proxy;


/**
 * Cxg\[XƃCxgnhڑ邽߂̘gg݂񋟂܂. ̘gg݂𗘗p邽߂ɂ,
 * Dynamic Proxy Class API  VM T|[gĂKv܂.
 * @author	$Author: ppoi $
 */
public class GenericListener	{

	/**
	 * <code>GenericListener</code> ̓CX^X𐶐ł܂B
	 */
	private GenericListener(){;}


	/**
	 * Cxg\[XƃCxgnhڑ܂B̃\bhœo^ꍇACxgnh̓Cxg\[XƓXbhŎs܂B
	 * @param	eventSource		Cxg\[X
	 * @param	eventTarget		Cxgnh
	 * @param	listenerClass	Cxg\[Xɖ{ڑ郊XiNX
	 * @param	sourceMethod	Cxg\[XŌĂяo郁\bh
	 * @param	targetMethod	CxgnhŎۂɃCxg郁\bh
	 * @return	Cxg\[XƃCxgnhڑꂽꍇ <code>true</code>
	 */
	public static boolean connect( Object eventSource, Object eventTarget, Class listenerClass, String sourceMethod, String targetMethod )
	{
		return connect( eventSource, eventTarget, listenerClass, sourceMethod, targetMethod, false );
	}

	/**
	 * Cxg\[XƃCxgnhڑ܂B
	 * VXbhNăCxgnhsꍇA߂lԂƂ͏o܂B܂AO̔͒ʒm܂B
	 * @param	eventSource		Cxg\[X
	 * @param	eventTarget		Cxgnh
	 * @param	listenerClass	Cxg\[Xɖ{ڑ郊XiNX
	 * @param	sourceMethod	Cxg\[XŌĂяo郁\bh
	 * @param	targetMethod	CxgnhŎۂɃCxg郁\bh
	 * @param	newThread	VXbhNăCxgnhsꍇ <code>true</code>AȊȌꍇ <code>false</code>
	 * @return	Cxg\[XƃCxgnhڑꂽꍇ <code>true</code>
	 */
	public static boolean connect( Object eventSource, Object eventTarget, Class listenerClass, String sourceMethod, String targetMethod, boolean newThread )
	{
		try	{
		//	"add" \bh̎擾.
		Method	addMethod = eventSource.getClass().getMethod( ("add" + identifierOf(listenerClass)), new Class[]{listenerClass} );
		if( addMethod == null )	{
			//	G[
			return false;
		}

		//	XĩCX^X̎擾.
		Method	sourceMethodObject = getListenerMethod( listenerClass, sourceMethod );
		Method	targetMethodObject = getTargetMethod( eventTarget.getClass(), targetMethod, sourceMethodObject.getParameterTypes() );
		Object	listenerImple = Proxy.newProxyInstance( Thread.currentThread().getContextClassLoader(), new Class[]{listenerClass}, new InvocHandler(eventTarget, targetMethodObject, sourceMethodObject, newThread) );

		addMethod.invoke( eventSource, new Object[]{listenerImple} );
		}
		catch( Exception e )
		{
			e.printStackTrace();
			return false;
		}

		return true;
	}

	/**
	 * w肳ꂽNX Identifier 擾܂. ł Identidier ̓NX錾̍ۂ
	 *pNX̂Ƃw܂.
	 * @param	c	Identifier 擾NX
	 * @return	Identifier
	 */
	private static String identifierOf( Class c )
	{
		String	className = c.getName();
		return className.substring( className.lastIndexOf('.') + 1, className.length() );
	}

	/**
	 * Cxg\[XŌĂяo郁\bh擾܂.
	 * @param	listenerClass	XiNX
	 * @param	methodName		\bh
	 */
	private static Method getListenerMethod( Class listenerClass, String methodName )
		throws NoSuchMethodException
	{
		Method	methods[] = listenerClass.getMethods();
		for( int i = methods.length - 1; i >= 0; --i )	{
			if( methodName.equals(methods[i].getName()) )	{
				return methods[i];
			}
		}
		throw new NoSuchMethodException( "No such method \"" + methodName + "\" in \"" + listenerClass.getName() + "\"." );
	}

	/**
	 * w肳ꂽNXɂĎw肳ꂽOŒ`ꂽ\bh擾܂.
	 * @param	c	\bh`ĂNX
	 * @param	methodName	\bh
	 * @param	parameterTypes	̌^Xg
	 */
	private static Method getTargetMethod( Class c, String methodName, Class[] parameterTypes )
		throws NoSuchMethodException
	{
		Method	method = null;
		try	{
			method = c.getDeclaredMethod( methodName, parameterTypes );
		}
		catch( NoSuchMethodException nsme )	{
			method = c.getDeclaredMethod( methodName, null );
		}

		try	{
			method.setAccessible( true );
		}
		catch( SecurityException se )	{
			//	ignore.
		}
		return method;
	}
}


/**
 * <code>InvocationHandler</code> ̎ł.
 */
class InvocHandler	implements InvocationHandler	{

	/**
	 * ۂɍsNX
	 */
	private Object	_target =null;

	/**
	 * ۂɍs\bh
	 */
	private Method	_targetMethod = null;

	/**
	 * Cxg\[XɂČĂяo郁\bh
	 */
	private Method	_sourceMethod = null;

	/**
	 * ʃXbhN邩ǂ
	 */
	private boolean	_newThread = false;


	/**
	 * <code>InvocHandler</code> ̃CX^X𐶐܂.
	 * @param	target	ۂ̃Cxgnh
	 * @param	targetMethod	ۂɏs\bh
	 * @param	sourceMethod	Cxg\[XɂČĂяo郁\bh
	 */
	InvocHandler( Object target, Method targetMethod, Method sourceMethod, boolean newThread )
	{
		_target = target;
		_targetMethod = targetMethod;
		_sourceMethod = sourceMethod;
		_newThread = newThread;
	}


//
//	InvocationHandler ̎
//
	/**
	 * Processes a method invocation on a proxy instance and returns the result. This method
	 * will be invoked on an invocation handler when a method is invoked on a proxy instance
	 * that it is associated with.
	 * @param	proxy	the proxy instance that the method was invoked on
	 * @param	meth	the Method instance corresponding to the interface method invoked on
	 * the proxy instance. The declaring class of the Method object will be the interface that
	 * the method was declared in, which may be a superinterface of the proxy interface that
	 * the proxy class inherits the method through.
	 * @param	args	an array of objects containing the values of the arguments passed in
	 * the method invocation on the proxy instance, or null if interface method takes no arguments.
	 * Arguments of primitive types are wrapped in instances of the appropriate primitive wrapper
	 * class, such as <code>java.lang.Integer</code> or <code>java.lang.Boolean</code>.
	 * @return	the value to return from the method invocation on the proxy instance. If the
	 * declared return type of the interface method is a primitive type, then the value returned
	 * by this method must be an instance of the corresponding primitive wrapper class; otherwise,
	 * it must be a type assignable to the declared return type. If the value returned by this
	 * method is <code>null</code> and the interface method's return type is primitive, then a
	 * <code>NullPointerException<code> will be thrown by the method invocation on the proxy
	 * instance. If the value returned by this method is otherwise not compatible with the
	 * interface method's declared return type as described above, a <code>ClassCastException</code>
	 * will be thrown by the method invocation on the proxy instance
	 */
	public Object invoke( Object proxy, Method meth, Object[] args )
		throws NoSuchMethodException, IllegalAccessException, InvocationTargetException
	{
		if( !_sourceMethod.equals(meth) )	{
			return null;
		}

		if( _targetMethod.getParameterTypes().length == 0 )	{
			args = null;
		}

		if( _newThread )	{
			new Thread( new InvokerRunner(_target, _targetMethod, args) ).start();
			return null;
		}
		else	{
			return _targetMethod.invoke( _target, args );
		}
	}
}

class InvokerRunner implements Runnable	{

	protected Object	_target = null;

	protected Method	_method = null;

	protected Object[]	_args = null;


	InvokerRunner( Object target, Method method, Object[] args )
	{
		super();
		_target = target;
		_method = method;
		_args = args;
	}


	public void run()
	{
		try	{
			_method.invoke( _target, _args );
		}
		catch( Exception e )	{
			//ignore.
		}
	}
}