package tsukuba_bunko.resource.test;

import	java.net.URL;

import	tsukuba_bunko.resource.IllegalResourceException;
import	tsukuba_bunko.resource.Resources;

import	junit.framework.TestCase;

/**
 * <code>StringDeserializer</code> eXg TestCase ł.
 * @author	$Author: ppoi $
 * @see	tsukuba_bunko.resource.StringDeserializer
 */
public class StringDeserializerTestCase	extends TestCase	{

	/**
	 * <code>StringDeserializerTestCase</code> ̃CX^X쐬܂.
	 */
	public StringDeserializerTestCase( String name )
	{
		super( name );
	}


	public void testLoad()
		throws Exception
	{
		URL	resourceURL = getClass().getResource( "test-string.xml" );
		assertNotNull( "resource file not found", resourceURL );

		System.setProperty( "libtbas.resource.mapping", "tsukuba_bunko.resource.test.test_mapping" );
		Resources	resources = Resources.newInstance( resourceURL );

		String	value = (String)resources.getResource( "tbas.libtbas.resource-manager.test.item1" );
		assertNotNull( "item1", value );
		assertEquals( "item1", value, "item1" );

		value = (String)resources.getResource( "tbas.libtbas.resource-manager.test.item2" );
		assertNotNull( "item2", value );
		assertEquals( "item2", value, "2" );

		value = (String)resources.getResource( "tbas.libtbas.resource-manager.hoge" );
		assertNotNull( "hoge", value );
		assertEquals( "hoge", value, "ق" );
	}

	public void testLoadIllegal()
		throws Exception
	{
		URL	resourceURL = getClass().getResource( "test-string-illegal.xml" );
		assertNotNull( "resource file not found", resourceURL );

		try	{
			System.setProperty( "libtbas.resource.mapping", "tsukuba_bunko.resource.test.test_mapping" );
			Resources.newInstance( resourceURL );
			assertTrue( "exception", false );
		}
		catch( IllegalResourceException ire )	{
			ire.printStackTrace();
		}
	}
}
