/*
 * Common Library for TBAS Softwares
 *
 * All Rights Reserved.
 * (c) Copyright 2002 by Tsukuba Bunko.
 *
 * $Id: ResourcesTestCase.java,v 1.1 2003/08/31 08:20:49 ppoi Exp $
 */
package tsukuba_bunko.resource.test;

import	java.net.URL;

import	tsukuba_bunko.resource.Resources;

import	junit.framework.TestCase;


/**
 * <code>Resources</code> eXg TestCase ł.
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1 $
 * @see	tsukuba_bunko.util.Resources
 */
public class ResourcesTestCase	extends TestCase	{

	/**
	 * <code>ResourcesTestCase</code> ̃CX^X쐬܂.
	 */
	public ResourcesTestCase( String name )
	{
		super( name );
	}


	/**
	 * RXgN^eXg܂(n).
	 */
	public void testNewInstance()
		throws Exception
	{
		URL	resourceURL = getClass().getResource( "test-normal.xml" );
		assertNotNull( "resource not found.", resourceURL );

		Resources.newInstance( resourceURL );
	}

	/**
	 * getResource() eXg܂(n).
	 */
	public void testGetResource()
		throws Exception
	{
		URL	resourceURL = getClass().getResource( "test-normal.xml" );
		assertNotNull( "resource not found.", resourceURL );

		Resources	resources = Resources.newInstance( resourceURL );
		String	item1 = (String)resources.getResource( "tbas.libtbas.resource-manager.test.item1" );
		assertNotNull( "item1", item1 );
		assertEquals( "item1", item1, "1" );

		Integer	item2 = (Integer)resources.getResource( "tbas.libtbas.resource-manager.test.item2" );
		assertNotNull( "item2", item2 );
		assertEquals( "item2", item2, new Integer(2) );

		String	itemHoge = (String)resources.getResource( "tbas.libtbas.hoge" );
		assertNotNull( "hoge", itemHoge );
		assertEquals( "hoge", itemHoge, "ق" );
	}

	/**
	 * getResource() eXg܂(ُn).
	 */
	public void testGetResourceIllegal()
		throws Exception
	{
		URL	resourceURL = getClass().getResource( "test-normal.xml" );
		assertNotNull( "resource not found.", resourceURL );

		Resources	resources = Resources.newInstance( resourceURL );
		assertNull( "invalid return", resources.getResource("nonexitst") );
	}
}
