/*
 * Common Library for TBAS Softwares
 * Language: Java
 *
 * All Rights Reserved.
 * (c) Copyright 2002 by Tsukuba Bunko.
 *
 * $Id: Resources.java,v 1.2 2003/09/11 10:30:07 ppoi Exp $
 */
package tsukuba_bunko.resource;

import	java.io.IOException;

import	java.net.URL;

import	java.util.Map;

import	javax.xml.parsers.ParserConfigurationException;

import	org.xml.sax.SAXException;


/**
 * \[Xƃ\[XID̊֘AǗ܂B
 * @author	$Author: ppoi $
 * @version	$Revision: 1.2 $
 */
public class Resources	{

	/**
	 * \[X
	 */
	private Map	_resources = null;


	/**
	 * <code>Resources</code> ̃CX^X쐬܂B
	 */
	public Resources()
	{
		_resources = new java.util.HashMap( 89 );
	}


	/**
	 * \[X擾܂B
	 * @param	resourceName	\[X
	 * @return	\[X
	 */
	public Object getResource( String resourceName )
	{
		return _resources.get( resourceName );
	}

	/**
	 * \[Xݒ肵܂B{@link #setEmutable()} Ăяoɂ̃\bhĂяoꍇA{@link java.util.UnsupportedOperationException}  throw ܂B
	 * @param	resourceName	\[X
	 * @param	resource	\[X
	 * @throws	UnsupportedOperationException	{@link #setEmutable()} Ăяoɂ̃\bhĂяoꍇ
	 */
	public final void setResource( String resourceName, Object resource )
	{
		_resources.put( resourceName, resource );
	}

	/**
	 *  <code>Resources</code> ǗS\[XID擾܂B
	 * @return	\[XID̔z
	 */
	public String[] getResourceIDs()
	{
		return (String[])_resources.keySet().toArray( new String[_resources.size()] );
	}

	/**
	 * \[Xt@C烊\[X[hA<code>Resources</code> ̃CX^X쐬܂.
	 * @param	resourceURL	\[Xt@C URL
	 * @return	ꂽ <code>Resources</code>
	 * @throws	IllegalResourceException	\[Xt@Csȏꍇ
	 * @throws	ParserConfigurationException	JAXP ɍ\ĂȂꍇ
	 * @throws	SAXException	JAXP ɍ\ĂȂꍇ
	 * @throws	IOException	I/O G[ꍇ
	 */
	public static Resources newInstance( URL resourceURL )
		throws IllegalResourceException, ParserConfigurationException, SAXException, IOException
	{
		Resources	resources = new Resources();
		ResourceLoader	loader = new ResourceLoader();
		loader.loadResource( resourceURL, resources );
		return resources;
	}
}