package tsukuba_bunko.resource;

import	org.xml.sax.SAXException;


/**
 * <code>java.lang.Number</code> n̒lfVACY <code>ResourceDeserializer</code> ł.
 * @author	$Author: ppoi $
 */
public class NumberDeserializer	extends SimpleDeserializer	{

	/**
	 * ^
	 */
	private String	_type = null;

	/**
	 * <code>NumberDeserializer</code> ̃CX^X쐬܂.
	 */
	public NumberDeserializer()
	{
		super();
	}


//
//	SimpleDeserializer ̎
//
	protected Object convertValue( String source )
		throws SAXException
	{
		try	{
			String	type = getTypeName();
			Number	value = null;
			if( type.equals("integer") )	{
				value = Integer.valueOf( source );
			}
			else if( type.equals("long") )	{
				value = Long.valueOf( source );
			}
			else if( type.equals("double") )	{
				value = Double.valueOf( source );
			}
			else if( type.equals("float") )	{
				value = Float.valueOf( source );
			}
			else if( type.equals("short") )	{
				value = Short.valueOf( source );
			}
			else if( type.equals("byte") )	{
				value = Byte.valueOf( source );
			}
			else	{
				throw new SAXException( "unsupported type \"" + _type + "\"" );
			}
			return value;
		}
		catch( NumberFormatException nfe )	{
			System.err.println( "[hogehgoe]" );
			nfe.printStackTrace();
			throw new SAXException( nfe );
		}
	}
}
