/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: FlagHandler.java,v 1.1.2.1 2003/12/11 10:17:57 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario.util;

import	org.xml.sax.Attributes;

import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.peko.scenario.ElementHandler;
import	tsukuba_bunko.peko.scenario.FlagScope;
import	tsukuba_bunko.peko.scenario.PSMLUtil;


/**
 * <samp>flag</samp> vf ElementHandler łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class FlagHandler	extends ElementHandler	{

	/**
	 * tO ID
	 */
	private String	_flagID = null;

	/**
	 * tOXR[v
	 */
	private FlagScope	_scope = null;

	/**
	 * tO𗧂Ă邩~낷
	 */
	private boolean	_declare = true;


	/**
	 * <code>FlagHandler</code> ̃CX^X𐶐܂B
	 */
	public FlagHandler()
	{
		super();
	}


//
//	ContentHandler ̎
//
	public void startDocument()
	{
		_flagID = null;
		_declare = true;
		_scope = null;
	}

	public void endDocument()
	{
		if( _flagID != null )	{
			if( _declare )	{
				getSceneContext().declareFlag( _flagID, _scope );
			}
			else	{
				getSceneContext().undeclareFlag( _flagID, _scope );
			}
		}
	}

	public void startElement( String namespaceURI, String localname, String qName, Attributes attrs )
	{
		String	flagID = PSMLUtil.getAttributeValue( attrs, "id" );
		if( flagID == null )	{
			Logger.error( MessageIDs.SCN6002W, new Object[]{getSceneContext().getCurrentPath()} );
		}
		else	{
			_flagID = flagID;
		}

		String	scope = PSMLUtil.getAttributeValue( attrs, "scope" );
		if( "scene".equals(scope) )	{
			_scope = FlagScope.SCENE;
		}
		else if( "session".equals(scope) )	{
			_scope = FlagScope.SESSION;
		}
		else if( "system".equals(scope) )	{
			_scope = FlagScope.SYSTEM;
		}
		else	{
			Logger.error( MessageIDs.SCN6003W, new Object[]{((scope == null)?"null":scope), getSceneContext().getCurrentPath()} );
			_flagID = null;
		}

		String	action = PSMLUtil.getAttributeValue( attrs, "action" );
		if( action != null )	{
			if( "undeclare".equals(action) )	{
				_declare = false;
			}
			else if( "declare".equals(action) )	{
				_declare = true;
			}
			else	{
				Logger.warn( MessageIDs.SCN6004W, new Object[]{getSceneContext().getCurrentPath()} );
				_flagID = null;
			}
		}
		else	{
			_declare = true;
		}
	}
}