/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: ParagraphHandler.java,v 1.1.2.1 2003/12/11 10:17:57 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario.text;

import	org.xml.sax.Attributes;

import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.peko.scenario.FlagScope;
import	tsukuba_bunko.peko.scenario.PSMLUtil;


/**
 * <samp>p</samp> vf̏s <code>ElementHandler</code> łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class ParagraphHandler	extends TextElementHandler	{

	/**
	 * eLXgobt@
	 */
	private StringBuffer	_text = null;

	/**
	 * ̗vf̕]Iɐݒ肳tO
	 */
	private String	_flagID = null;


	/**
	 * <code>ParagraphHandler</code> ̃CX^X쐬܂B
	 */
	public ParagraphHandler()
	{
		super();
	}


	/**
	 * pOt\܂B
	 */
	public void performParagraph()
	{
		TextCoordinator	coordinator = getTextCoordinator();
		coordinator.pushText( new String(_text) );
		_text = new StringBuffer( 48 );
	}


//
//	ContentHandler ̎
//
	public void startDocument()
	{
		Logger.debug( "[scene] start paragraph" );
		_text = new StringBuffer( 48 );
		_flagID = null;
		getTextCoordinator().begin();
	}

	public void endDocument()
	{
		Logger.debug( "[scene] end paragraph" );
		performParagraph();
		_text = null;
		stop();
		getTextCoordinator().commit();

		if( _flagID != null )	{
			getSceneContext().declareFlag( _flagID, FlagScope.SESSION );
		}
	}

	public void startElement( String namespaceURI, String localName, String qName, Attributes attrs )
	{
		if( localName.equals("wait") )	{
			performParagraph();
			//PENDING
			stop();	//	eXgpłI
		}
		else if( localName.equals("p") )	{
			_flagID = PSMLUtil.getAttributeValue( attrs, "flag" );
		}
	}

	public void endElement( String namespaceURI, String localName, String qName )
	{
		//	X^C܂ł͋̂܂܂łB
	}

	public void characters( char[] ch, int begin, int length )
	{
		_text.append( ch, begin, length );
	}
}
