/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: StageCoordinator.java,v 1.1.2.1 2003/12/11 10:15:10 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario.stage;

import	tsukuba_bunko.peko.ActionControler;

import	tsukuba_bunko.peko.canvas.stage.Actor;
import	tsukuba_bunko.peko.canvas.stage.Stage;

import tsukuba_bunko.peko.scenario.Coordinator;
import	tsukuba_bunko.peko.scenario.SceneContext;


/**
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class StageCoordinator	extends Coordinator	{

	/**
	 * ʒuF
	 */
	public static final int	POSITION_CENTER = 0;

	/**
	 * ʒuF
	 */
	public static final int	POSITION_LEFT = 1;

	/**
	 * ʒuFE
	 */
	public static final int	POSITION_RIGHT = 2;


	/**
	 * lXgx
	 */
	protected int	_level = 0;


	/**
	 * <code>StageCoordinator</code> ̃CX^X𐶐܂B
	 */
	public StageCoordinator()
	{
		super();
	}


	/**
	 * <code>name</code> Ŏʂ҂̏擾܂B
	 * @param	name	Җ
	 * @return	Actor IuWFNgBY҂Ȃꍇ <code>null</code>
	 */
	public Actor getActor( String name )
	{
		Actor	actor = getStage().getActor( name );
		if( actor == null )	{
			return null;
		}
		else	{
			Actor	copy = new Actor( actor.getName() );
			actor.copyTo( copy );
			return copy;
		}
	}


	/**
	 * ҂𕑑ɓoꂳ܂B
	 * @param	actor	oꂷ
	 */
	public void enter( Actor actor )
	{
		if( isActiveThread() )	{
			getStage().enter( actor );
		}
	}

	/**
	 * ҂𓮂܂B
	 * @param	actor	
	 */
	public void action( Actor actor )
	{
		if( isActiveThread() )	{
			Stage	stage = getStage();
			Actor	current = stage.getActor( actor.getName() );
			if( current != null )	{
				if( current.getLooksImage() != actor.getLooksImage() )	{
					stage.exit( actor.getName() );
					stage.enter( actor );
				}
				else	{
					stage.enter( actor );
				}
			}
		}
	}

	/**
	 * ҂ޏꂳ܂B
	 * @param	name	ޏꂳҖ
	 * @return	ޏꂵ
	 */
	public Actor exit( String name )
	{
		if( isActiveThread() )	{
			return getStage().exit( name );
		}
		else	{
			return null;
		}
	}

	/**
	 * wiw肵Fɐݒ肵܂B
	 * @param	color	F
	 */
	public void setBackgroundColor( String color )
	{
		if( isActiveThread() )	{
			getStage().setBackgroundColor( color );
		}
	}

	/**
	 * wiw肳ꂽ摜ɐݒ肵܂B
	 * @param	image	摜
	 */
	public void setBackgroundImage( String image )
	{
		if( isActiveThread() )	{
			getStage().setBackgroundImage( image );
		}
	}

	/**
	 * XCh\܂B
	 * @param	slide	XCh
	 */
	public void showSlide( String slide )
	{
		if( isActiveThread() )	{
			getStage().showSlide( slide );
		}
	}

	/**
	 * XChB܂B
	 */
	public void hideSlide()
	{
		if( isActiveThread() )	{
			getStage().hideSlide();
		}
	}

	/**
	 * BGM Đ܂B
	 * @param	id	BGM ID
	 * @param	clipName	Nbv
	 * @param	loop	[vꍇ <code>true</code>AȊȌꍇ <code>false</code>
	 */
	public void playBGM( String id, String clipName, boolean loop )
	{
		if( isActiveThread() )	{
			getStage().playBGM( id, clipName, loop );
		}
	}

	/**
	 * BGM ~܂B
	 * @param	id	BGM ID
	 */
	public void stopBGM( String id )
	{
		if( isActiveThread() )	{
			getStage().stopBGM( id );
		}
	}

	/**
	 * SE Đ܂B
	 * @param	id	SE ID
	 * @param	clipName	Nbv
	 * @param	loop	[vꍇ <code>true</code>AȊȌꍇ <code>false</code>
	 */
	public void playSE( String id, String clipName, boolean loop )
	{
		if( isActiveThread() )	{
			getStage().playSE( id, clipName, loop );
		}
	}

	/**
	 * SE ~܂B
	 * @param	id	SE ID
	 */
	public void stopSE( String id )
	{
		if( isActiveThread() )	{
			getStage().stopSE( id );
		}
	}

	/**
	 * Xe[Ww肳ꂽGtFNggpčXV܂B
	 * @param	effect	GtFNg
	 */
	public void updateStage( String effect )
	{
		if( _level > 1 )	{
			return;
		}

		Stage	stage = getStage();
		stage.updateCanvas( effect );
	}

	/**
	 * GtFNggpɃXe[WXV܂B
	 */
	public void updateStage()
	{
		if( isActiveThread() )	{
			updateStage( null );
		}
	}

	/**
	 * eLXgLoXB܂B
	 */
	public void hideTextCanvas()
	{
		if( isActiveThread() )	{
			getCanvasManager().hideTextCanvas();
		}
	}

	/**
	 * Xe[W擾܂B
	 * @return	Xe[W
	 */
	protected Stage getStage()
	{
		return getCanvasManager().getStage();
	}


//
//	Coordinator ̎
//
	public void prepare( SceneContext context, Thread activeThread )
	{
		super.prepare( context, activeThread );
		_level = 0;
	}

	/**
	 * StageCanvas ɑ΂鑀Jn܂B
	 */
	public void begin()
	{
		if( isActiveThread() )	{
			_level++;
			getCanvasManager().hideTextCanvas();
			getActionControler().setActive( false );
			getActionControler().setSaveEnabled( true );
		}
	}

	/**
	 * StageCanvas ɑ΂鑀IALoX̏Ԃm肵܂B
	 */
	public void commit()
	{
		if( isActiveThread() )	{
			_level--;
			if( _level == 0 )	{
				ActionControler	controler = getActionControler();
				controler.setActive( true );
				controler.setSaveEnabled( false );
				Stage	stage = getStage();
				stage.commit();
			}
		}
	}
}