/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: SelectCoordinator.java,v 1.1.2.1 2003/12/11 10:15:10 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario.select;

import	java.util.List;

import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.peko.canvas.CanvasManager;

import	tsukuba_bunko.peko.canvas.select.SelectItem;

import	tsukuba_bunko.peko.scenario.Coordinator;


/**
 * SelectCanvas ɑ΂鏈莝R[fBl[^W[łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class SelectCoordinator	extends Coordinator	{

	/**
	 * IXg
	 */
	protected List	_selectItems = null;

	/**
	 * ݃ANeBuȃXbh
	 */
	protected Thread	_activeThread = null;


	/**
	 * <code>SelectCoordinator</code> ̃CX^X𐶐܂B
	 */
	public SelectCoordinator()
	{
		super();
	}


	/**
	 * SelectCanvas ɑ΂鑀Jn܂B
	 */
	public void begin()
	{
		if( isActiveThread() )	{
			getActionControler().setSaveEnabled( true );
			_selectItems = new java.util.ArrayList( 4 );
		}
	}

	/**
	 * SelectCanvas ɑ΂鑀IALoX̏Ԃm肵܂B
	 */
	public void commit()
	{
		if( isActiveThread() )	{
			getActionControler().setSaveEnabled( false );
		}
	}

	/**
	 * Iǉ܂B
	 * @param	id	I ID
	 * @param	text	I̕
	 */
	public void addSelectItem( String id, String text )
	{
		if( id == null )	{
			throw new IllegalArgumentException( "id is not specified." );
		}
		else if( text == null)	{
			throw new IllegalArgumentException( "text is not specified." );
		}

		if( isActiveThread() )	{
			SelectItem	item = new SelectItem();
			item.setID( id );
			item.setText( text );
			_selectItems.add( item );
		}
	}

	/**
	 * [U[ɑ΂I\AIꂽ ID 擾܂B
	 * @return	IꂽȊI ID
	 */
	public String select()
	{
		if( isActiveThread() )	{
			if( (_selectItems == null) || _selectItems.isEmpty() )	{
				Logger.debug( "[scenario.select] no select items!" );
				return null;
			}
			else	{
				CanvasManager	canvasManager = getCanvasManager();
				String	id = canvasManager.showSelect( _selectItems );
				if( id == null )	{
					Logger.debug( "[scenario.select] canceled." );
				}
				canvasManager.advancesNewPage();
				return id;
			}
		}
		else	{
			return null;
		}
	}

	/**
	 * SelectCanvas ɑ΂鑀I܂B
	 */
	public void end()
	{
		if( isActiveThread() )	{
			_activeThread = null;
			if( _selectItems != null )	{
				_selectItems.clear();
				_selectItems = null;
			}
		}
	}
}
