/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: InsetsDeserializer.java,v 1.1.2.1 2003/12/11 11:11:53 ppoi Exp $
 */
package tsukuba_bunko.peko.resource;

import	java.awt.Insets;

import	tsukuba_bunko.resource.SimpleDeserializer;


/**
 * {@link java.awt.Insets} ^̃\[Xɑ΂ {@link tsukuba_bunko.resource.ResourceDeserializer} łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 * @see <a href="http://softlab.tsukuba-bunko.org/peko/userguide/resource.html#type-peko:insets">peko:insets ^̃\[X</a>
 */
public class InsetsDeserializer	extends SimpleDeserializer	{

	/**
	 * <code>InsetsDeserializer</code> ̃CX^X쐬܂B
	 */
	public InsetsDeserializer()
	{
		super();
	}


//
//	SimpleDeserializer ̎
//
	protected Object convertValue( String source )
	{
		return parseInsets( source );
	}


	/**
	 * <code>source</code>  Insets Ƃĉ͂܂B
	 * @param	source	͌̕
	 * @return	͌
	 */
	public static Insets parseInsets( String source )
	{
		try	{
			int	top, right, bottom, left;
			int	begin = 0;
			int	end = source.indexOf( ',' );
			if( end == -1 )	{
				top = Integer.parseInt( source.trim() );
				return new Insets( top, top, top, top );
			}
			else	{
				top = Integer.parseInt( source.substring(begin, end).trim() );
			}

			begin = end + 1;
			end = source.indexOf( ',', begin );
			if( end == -1 )	{
				right = Integer.parseInt( source.substring(begin).trim() );
				return new Insets( top, right, top, right );
			}
			else	{
				right = Integer.parseInt( source.substring(begin, end).trim() );
			}

			begin = end + 1;
			end = source.indexOf( ',', begin );
			if( end == -1 )	{
				bottom = Integer.parseInt( source.substring(begin).trim() );
				return new Insets( top, right, bottom, right );
			}
			else	{
				bottom = Integer.parseInt( source.substring(begin, end).trim() );
			}

			begin = end + 1;
			left = Integer.parseInt( source.substring(begin).trim() );

			return new Insets( top, left, bottom, right );
		}
		catch( Exception e )	{
			throw new IllegalArgumentException( e.getMessage() );
		}
	}
}
