/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: DimensionDeserializer.java,v 1.1.2.1 2003/12/11 11:11:53 ppoi Exp $
 */
package tsukuba_bunko.peko.resource;

import	java.awt.Dimension;

import	org.xml.sax.SAXException;

import	tsukuba_bunko.resource.SimpleDeserializer;


/**
 * {@link java.awt.Dimension} ^̃\[Xɑ΂ {@link tsukuba_bunko.resource.ResourceDeserializer} łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 * @see <a href="http://softlab.tsukuba-bunko.org/peko/userguide/resource.html#type-peko:dimension">peko:dimension ^̃\[X</a>
 */
public class DimensionDeserializer	extends SimpleDeserializer	{

	/**
	 * <code>DimensionDeserializer</code> ̃CX^X쐬܂B
	 */
	public DimensionDeserializer()
	{
		super();
	}


//
//	SimpleDeserializer ̎
//
	protected Object convertValue( String source )
		throws SAXException
	{
		try	{
			return DimensionDeserializer.parseDimension( source );
		}
		catch( Exception e )	{
			throw new SAXException( e );
		}
	}


	/**
	 * <code>source</code>  Dimension Ƃĉ͂܂B
	 * @param	source	͌̕
	 * @return	͌
	 */
	public static Dimension parseDimension( String source )
		throws IllegalArgumentException
	{
		try	{
			int	delm = source.indexOf( ',' );
			int	x = Integer.parseInt( source.substring(0, delm) );
			int	y = Integer.parseInt( source.substring(delm + 1) );
			return new Dimension( x, y );
		}
		catch( Exception e )	{
			throw new IllegalArgumentException( e.getMessage() );
		}
	}
}
