/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: Page.java,v 1.1.2.1 2003/12/11 10:22:54 ppoi Exp $
 */
package tsukuba_bunko.peko.canvas.text;

import	java.awt.Color;
import	java.awt.Dimension;
import	java.awt.Font;
import	java.awt.Insets;
import	java.awt.Point;

import	java.awt.font.FontRenderContext;

import	java.io.Serializable;

import	java.util.List;

import	tsukuba_bunko.peko.Logger;


/**
 * xɃLoXɕ\s̃Xg(= y[W)łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class Page	implements Cloneable, Serializable	{

	/**
	 * ̃y[W`悷eLXgLoX
	 */
	transient private TextCanvas	_canvas = null;


	/**
	 * committed lines
	 */
	private List	_committedLines = null;

	/**
	 * R~bgꂽ̃y[W̍
	 */
	private float	_commitedPageHeight = 0f;


	/**
	 * lines
	 */
	transient private List	_lines = null;

	/**
	 * ݂̃y[W̍
	 */
	transient private float	_pageHeight = 0f;

	/**
	 * dirty flag
	 */
	transient private boolean	_dirty = false;


	/**
	 * ftHgtHg
	 */
	transient private Font	_defaultFont = null;

	/**
	 * TCY
	 */
	private Dimension	_size = new Dimension();

	/**
	 * ʒu
	 */
	private Point	_location = new Point( 0, 0 );

	/**
	 * pfBO
	 */
	private Insets	_padding = new Insets( 10, 10, 10, 10 );

	/**
	 * OiF
	 */
	private Color	_foreground = Color.white;

	/**
	 * eF
	 */
	private Color	_shadow = Color.black;

	/**
	 * wiF
	 */
	private Color	_background = Color.black;

	/**
	 * wi̓x
	 */
	private float	_transparency = 0.5f;


	/**
	 * <code>Page</code> ̃CX^X쐬܂B
	 */
	public Page()
	{
		super();
	}


	/**
	 * ̃y[W`悷eLXgLoXݒ肵܂B
	 * @param	canvas	eLXgLoX
	 */
	void setTextCanvas( TextCanvas canvas )
	{
		_canvas = canvas;
	}

	/**
	 * ̃y[W`悷eLXgLoX擾܂B
	 * @return	canvas
	 */
	public TextCanvas getTextCanvas()
	{
		return _canvas;
	}


	/**
	 * ftHgtHgݒ肵܂B
	 * @param	font	ftHgtHg
	 */
	public void setDefaultFont( Font font )
	{
		_defaultFont = font;
	}

	/**
	 * ftHgtHg擾܂B
	 * @return	ftHgtHg
	 */
	public Font getDefaultFont()
	{
		return _defaultFont;
	}

	/**
	 * ̃y[WŃeLXg`悷ۂɎgp FontRenderContext 擾܂B
	 * @return	`Ɏgp FontRenderContext CX^X
	 */
	public FontRenderContext getFontRenderContext()
	{
		if( _canvas == null )	{
			return null;
		}
		else	{
			return _canvas.getFontRenderContext();
		}
	}

	/**
	 * \̈̃TCYݒ肵܂B
	 * @param	page	TCY
	 */
	public void setSize( Dimension size )
	{
		_size.setSize( size );
	}

	/**
	 * \̈̃TCY擾܂B
	 * @return	\̈̃TCYi[ Dimension CX^X
	 */
	public Dimension getSize()
	{
		return getSize( new Dimension() );
	}

	/**
	 * \̈̃TCY擾A<code>d</code> Ɋi[܂B
	 * @param	d	\̈̃TCYi[ Dimension CX^X
	 * @return	<code>d</code>B<code>d == null</code> ̏ꍇ͐VKɐꂽ Dimension CX^X
	 */
	public Dimension getSize( Dimension d )
	{
		if( d == null )	{
			d = new Dimension();
		}
		d.setSize( _size );
		return d;
	}

	/**
	 * \̈̈ʒuݒ肵܂B
	 * @param	x	\̈̍ x W
	 * @param	y	\̈̍ y W
	 */
	public void setLocation( int x, int y )
	{
		_location.x = x;
		_location.y = y;
	}

	/**
	 * }[Ẅ̃TCY擾܂B
	 * @return	}[Ẅ̃TCYi[ Insets CX^X
	 */
	public Point getMargin()
	{
		return getLocation( null );
	}

	/**
	 * }[Ẅ̃TCY擾A<code>margin</code> Ɋi[ĕԂ܂B
	 * @param	margin	}[Ẅ̃TCYi[ Insets CX^X
	 * @return	<code>margin</code>B<code>margin == null</code> ̏ꍇ͐VKɐꂽ Insets CX^X
	 */
	public Point getLocation( Point location )
	{
		if( location == null )	{
			location = (Point)_location.clone();
		}
		else	{
			location.x = _location.x;
			location.y = _location.y;
		}
		return location;
	}

	/**
	 * pfBÖ̃TCYݒ肵܂B
	 * @param	top	padding-top
	 * @param	left	padding-left
	 * @param	bottom	padding-bottom
	 * @param	right	padding-right
	 */
	public void setPadding( int top, int left, int bottom, int right )
	{
		_padding.top = top;
		_padding.left = left;
		_padding.bottom = bottom;
		_padding.right = right;
	}

	/**
	 * pfBÖ̃TCY擾܂B
	 * @return	pfBÖ̃TCYi[ Insets CX^X
	 */
	public Insets getPadding()
	{
		return getPadding( null );
	}

	/**
	 * pfBÖ̃TCY擾A<code>padding</code> Ɋi[ĕԂ܂B
	 * @param	padding	pfBÖ̃TCYi[ Insets CX^X
	 * @return	<code>padding</code>B<code>padding == null</code> ̏ꍇ́AVKɐꂽ Insets CX^X
	 */
	public Insets getPadding( Insets padding )
	{
		if( padding == null )	{
			padding = (Insets)_padding.clone();
		}
		else	{
			padding.top = _padding.top;
			padding.left = _padding.left;
			padding.bottom = _padding.bottom;
			padding.right = _padding.right;
		}
		return padding;
	}

	/**
	 * OiFݒ肵܂B
	 * @param	foreground	OiF
	 */
	public void setForeground( Color foreground )
	{
		_foreground = foreground;
	}

	/**
	 * OiF擾܂B
	 * @return	OiF
	 */
	public Color getForeground()
	{
		return _foreground;
	}

	/**
	 * eFݒ肵܂B
	 * @param	shadow	eF
	 */
	public void setShadow( Color shadow )
	{
		_shadow = shadow;
	}

	/**
	 * eF擾܂B
	 * @return	eF
	 */
	public Color getShadow()
	{
		return _shadow;
	}

	/**
	 * wiFݒ肵܂B
	 * @param	background	wiF
	 */
	public void setBackground( Color background )
	{
		_background = background;
	}

	/**
	 * wiF擾܂B
	 * @return	wiF
	 */
	public Color getBackground()
	{
		return _background;
	}

	/**
	 * wiF̓xݒ肵܂.
	 * @param	trans	x
	 */
	public void setTransparency( float trans )
	{
		_transparency = trans;
	}

	/**
	 * wiF̓x擾܂B
	 * @return	x
	 */
	public float getTransparency()
	{
		return _transparency;
	}


	/**
	 * ̃y[Wŕ\\ȍs̍ől擾܂B
	 * @return	ős
	 */
	public float getMaxLineWidth()
	{
		int	width = _size.width;
		width -= _padding.left;
		width -= _padding.right;

		return (float)width;
	}

	/**
	 * s𖖔ɒǉ܂B
	 * @param	line	ǉs
	 */
	public synchronized void addLine( Line line )
	{
		if( _lines == null )	{
			_lines = new java.util.ArrayList();
		}
		_lines.add( line );
		_pageHeight += line.getAscent();
		_pageHeight += line.getDescent();
		_dirty = true;
	}

	/**
	 * ݃y[WɊ܂܂s擾܂B
	 * @return	s
	 */
	public int getLineCount()
	{
		if( _lines != null )	{
			return _lines.size();
		}
		else	{
			return 0;
		}
	}

	/**
	 * <code>index</code> Ŏw肳ꂽs <code>line</code> Œu܂B
	 * @param	index	us̃CfbNX
	 * @param	line	Vs
	 */
	public synchronized void setLine( int index, Line line )
	{
		try	{
			if( (_lines == null) || (index < 0) || (index >= _lines.size()) )	{
				Logger.debug( "[canvas.text] invalid length! index:" + index + " size:" + ((_lines != null)?_lines.size():0) );
			}

			synchronized( this )	{
				Line	old = (Line)_lines.get( index );
				_pageHeight -= (old.getAscent() + old.getDescent());
				_lines.set( index, line );
				_pageHeight += (line.getAscent() + line.getDescent());
				_dirty = true;
			}
		}
		catch( IndexOutOfBoundsException ioobe )	{
			Logger.error( "[canvas] invalid line number.", ioobe );
			throw ioobe;
		}
	}

	/**
	 * <code>index</code> Ŏw肳ꂽsy[W폜܂B<code>index</code>
	 * ̍s͈sɋl߂܂B
	 * @param	index	폜s̃CfbNX
	 * @throws	IndexOutOfBoundsException	<code>index</code> ͈͊Ȍꍇ
	 */
	public void removeLine( int index )
	{
		try	{
			if( _lines == null )	{
				throw new IndexOutOfBoundsException( "there is still no line." );
			}

			synchronized( this )	{
				Line	line = (Line)_lines.remove( index );
				_pageHeight -= (line.getAscent() + line.getDescent());
				_dirty = true;
			}
		}
		catch( IndexOutOfBoundsException ioobe )	{
			Logger.error( "[canvas] invalid line number.", ioobe );
			throw ioobe;
		}
	}

	/**
	 * sXg擾܂B
	 */
	public List getLines()
	{
		if( _lines != null )	{
			return (List)((java.util.ArrayList)_lines).clone();
		}
		else	{
			return null;
		}
	}

	/**
	 * ׂĂ̍sNA܂B
	 */
	public void clearLines()
	{
		synchronized( this )	{
			if( _lines != null )	{
				_lines.clear();
				_dirty = true;
				_pageHeight = 0f;
			}
		}
	}

	/**
	 * <code>line</code> y[Wɒǉ\ǂ𔻒肵܂B
	 * @param	line	肷s
	 * @return	ǉ\ȏꍇ <code>true</code>Aǉłȏꍇ <code>false</code>
	 */
	public boolean isAdaptive( Line line )
	{
		if( line == null )	{
			throw new NullPointerException( "Ă߂AȂ߂Ă񂶂˂炟I" );
		}
		float	pageHeight = _pageHeight + _padding.top + _padding.bottom;
		return ((pageHeight + line.getAscent() + line.getDescent()) < (float)_size.height);
	}


	/**
	 * ̃y[Wւ̕ύXLoXɔf܂B
	 */
	public void updateCanvas()
	{
		if( _canvas != null )	{
			_canvas.updateCanvas();
		}
	}

	/**
	 * ̃y[W̓eieLXgj̕ύXLoXɔf܂B
	 */
	public void updateContents()
	{
		if( _canvas != null )	{
			_canvas.updateText();
		}
	}

	/**
	 * ύXR~bg܂B
	 */
	public void commit()
	{
		Logger.debug( "[canvas.text] commit." );
		if( _lines != null )	{
			if( _committedLines != null )	{
				_committedLines.clear();
				_committedLines.addAll( _lines );
			}
			else	{
				_committedLines = (List)((java.util.ArrayList)_lines).clone();
			}
			Logger.debug( "[canvas.text] committed lines :" + _committedLines.size() );
		}
		_commitedPageHeight = _pageHeight;
	}

	/**
	 * R~bgĂȂύXj܂B
	 */
	public void rollback()
	{
		Logger.debug( "[canvas.text] rollback." );
		if( _lines != null )	{
			_lines.clear();
		}
		_lines = _committedLines;
		_committedLines = null;
		_pageHeight = _commitedPageHeight;
	}


//
//	Clonable ̎
//
	public Object clone()
	{
		return clone( new Page() );
	}

	/**
	 * <code>page</code> ̃y[W̃N[Ƃ܂B
	 * @param	copy	̃y[W̃N[ɂ Page CX^X
	 * @return	<code>copy</code>
	 */
	public Object clone( Page copy )
	{
		synchronized( this )	{
			if( _lines != null )	{
				copy._lines = (List)((java.util.ArrayList)_lines).clone();
			}
		}
		copy._dirty = false;
		copy._defaultFont = _defaultFont;
		copy._size = (Dimension)_size.clone();
		copy._location = (Point)_location.clone();
		copy._padding = (Insets)_padding.clone();
		copy._foreground = _foreground;
		copy._background = _background;
		copy._transparency = _transparency;

		return copy;
	}
}
