package tsukuba_bunko.resource.test;

import	java.net.URL;

import	tsukuba_bunko.resource.ResourceLoader;
import	tsukuba_bunko.resource.Resources;

import	junit.framework.TestCase;

/**
 * <code>ResourceLoader</code> eXg TestCase ł.
 */
public class ResourceLoaderTestCase	extends TestCase	{

	/**
	 * <code>ResourceLoaderTestCase</code> ̃CX^X쐬܂.
	 */
	public ResourceLoaderTestCase( String name )
	{
		super( name );
	}


	/**
	 * loadResource eXg܂.
	 */
	public void testLoadResource()
		throws Exception
	{
		Resources	resources = new Resources();
		ResourceLoader	loader = new ResourceLoader();

		URL	resourceURL = getClass().getResource( "test-resourceloader.xml" );
		assertNotNull( "resource file not found", resourceURL );
		loader.loadResource( resourceURL, resources );

		String	value = (String)resources.getResource( "tbas.libtbas.resource-manager.test.item1" );
		assertNotNull( "item1", value );
		assertEquals( "item1", value, "1" );

		value = (String)resources.getResource( "tbas.libtbas.resource-manager.test.item2" );
		assertNotNull( "item2", value );
		assertEquals( "item2", value, "2" );

		value = (String)resources.getResource( "tbas.libtbas.hoge" );
		assertNotNull( "hoge is null", value );
		assertEquals( "hoge", value, "ق" );
	}
}
