/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: SaveDataInfoRenderer.java,v 1.1.2.1 2003/12/11 10:12:19 ppoi Exp $
 */
package tsukuba_bunko.peko.session;

import	java.awt.Color;
import	java.awt.Component;
import	java.awt.Dimension;
import	java.awt.Font;
import	java.awt.Graphics;
import	java.awt.Graphics2D;
import	java.awt.RenderingHints;

import	java.awt.font.TextAttribute;
import	java.awt.font.TextLayout;

import	java.text.AttributedString;
import	java.text.MessageFormat;
import	java.text.SimpleDateFormat;

import	java.util.Map;

import	javax.swing.BorderFactory;
import javax.swing.JComponent;
import	javax.swing.JList;
import	javax.swing.ListCellRenderer;

import	tsukuba_bunko.peko.Logger;

import	tsukuba_bunko.peko.resource.ResourceManager;
import	tsukuba_bunko.peko.resource.ColorManager;
import	tsukuba_bunko.peko.resource.FontManager;


/**
 * Z[uf[^`悷 <code>ListCellRenderer</code> łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class SaveDataInfoRenderer	extends JComponent	implements ListCellRenderer	{

	/**
	 * `悷Z[uf[^
	 */
	private SaveDataInfo	_info = null;

	/**
	 * IĂ邩ǂ
	 */
	private boolean	_selected = false;

	/**
	 */
	private int	_index = -1;

	/**
	 * ZTCY
	 */
	private Dimension	_cellSize = null;

	/**
	 * I̔wiF
	 */
	private Color	_selectedBackground = null;

	/**
	 * I̔wiF
	 */
	private Color	_unselectedBackground = null;

	/**
	 * ^CgtHg
	 */
	private Font	_titleFont = null;

	/**
	 * ^CgOiF
	 */
	private Color	_titleColor = null;

	/**
	 * ^CX^vtHg
	 */
	private Font	_timestampFont = null;

	/**
	 * ^CX^vOiF
	 */
	private Color	_timestampColor = null;

	/**
	 * RgtHg
	 */
	private Font	_commentFont = null;

	/**
	 * RgOiF
	 */
	private Color	_commentColor;


	/**
	 * ^Cg̃tH[}bg
	 */
	private MessageFormat	_titleFormat = null;

	/**
	 * ^CX^ṽtH[}bg
	 */
	private SimpleDateFormat	_timestampFormat = null;

	/**
	 * o^Z̃^Cg
	 */
	private String	_nodataTitle = null;


	/**
	 * <code>SaveDataInfoRenderer</code> ̃CX^X𐶐܂B
	 */
	public SaveDataInfoRenderer()
	{
		ResourceManager	resources = ResourceManager.getInstance();
		ColorManager	colors = ColorManager.getInstance();
		FontManager	fonts = FontManager.getInstance();

		Dimension	size = (Dimension)resources.getResource( ResourceIDs.CELL_SIZE );
		if( size == null )	{
			Logger.warn( MessageIDs.SAV0009W, new Object[]{"380,65"} );
			size = new Dimension( 380, 65 );
		}
		setPreferredSize( size );
		setSize( size );
		_cellSize = size;

		_selectedBackground = (Color)resources.getResource( ResourceIDs.CELL_BACKGROUND_SELECTED );
		if( _selectedBackground == null )	{
			_selectedBackground = colors.getColor( "#FF88FF" );
			Logger.warn( MessageIDs.SAV0024W, new Object[]{"cell.background.selected", "#FF88FF"} );
		}

		_unselectedBackground = (Color)resources.getResource( ResourceIDs.CELL_BACKGROUND_UNSELECTED );
		if( _unselectedBackground == null )	{
			_unselectedBackground = colors.getColor( "white" );
			Logger.warn( MessageIDs.SAV0024W, new Object[]{"cell.background.unselected", "white"} );
		}

		_titleColor = (Color)resources.getResource( ResourceIDs.CELL_TITLE_COLOR );
		if( _titleColor == null )	{
			_titleColor = colors.getColor( "black" );
			Logger.warn( MessageIDs.SAV0023W, new Object[]{"cell.title", "black", } );
		}

		_timestampColor = (Color)resources.getResource( ResourceIDs.CELL_TIMESTAMP_COLOR );
		if( _timestampColor == null )	{
			_timestampColor = colors.getColor( "black" );
			Logger.warn( MessageIDs.SAV0023W, new Object[]{"cell.timestamp", "black"} );
		}

		_commentColor = (Color)resources.getResource( ResourceIDs.CELL_COMMENT_COLOR );
		if( _commentColor == null )	{
			_commentColor = colors.getColor( "black" );
			Logger.warn( MessageIDs.SAV0023W, new Object[]{"cell.comment", "black"} );
		}
		

		_titleFont = (Font)resources.getResource( ResourceIDs.CELL_TITLE_FONT );
		if( _titleFont == null )	{
			Logger.warn( MessageIDs.SAV0010W, new Object[]{"cell.title", "family:SansSerif; size:16.0; style:normal; weight:bold"} );
			Map	attributes = new java.util.HashMap();
			attributes.put( TextAttribute.FAMILY, "SansSerif" );
			attributes.put( TextAttribute.SIZE, new Float(16f) );
			attributes.put( TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR );
			attributes.put( TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD );
			_titleFont = fonts.getFont( attributes );
		}

		_timestampFont = (Font)resources.getResource( ResourceIDs.CELL_TIMESTAMP_FONT );
		if( _timestampFont == null )	{
			Logger.warn( MessageIDs.SAV0010W, new Object[]{"cell.timestamp", "family:SansSerif; size:11.0; style:normal; weight:normarl"} );
			Map	attributes = new java.util.HashMap();
			attributes.put( TextAttribute.FAMILY, "SansSerif" );
			attributes.put( TextAttribute.SIZE, new Float(11f) );
			attributes.put( TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR );
			attributes.put( TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD );
			_timestampFont = fonts.getFont( attributes );
		}

		_commentFont = (Font)resources.getResource( ResourceIDs.CELL_COMMENT_FONT );
		if( _timestampFont == null )	{
			Logger.warn( MessageIDs.SAV0010W, new Object[]{"cell.comment", "family:SansSerif; size:16.0; style:normal; weight:normarl"} );
			Map	attributes = new java.util.HashMap();
			attributes.put( TextAttribute.FAMILY, "SansSerif" );
			attributes.put( TextAttribute.SIZE, new Float(11f) );
			attributes.put( TextAttribute.POSTURE, TextAttribute.POSTURE_REGULAR );
			attributes.put( TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD );
			_commentFont = fonts.getFont( attributes );
		}

		_titleFormat = (MessageFormat)resources.getResource( ResourceIDs.CELL_TITLE_FORMAT );
		if( _titleFormat == null )	{
			_titleFormat = new MessageFormat( "No.{0}  {1}" );
			Logger.warn( MessageIDs.SAV0011W, new Object[]{"\"No.{0}  {1}\""} );
		}

		String	timestampFormat = (String)resources.getResource( ResourceIDs.CELL_TIMESTAMP_FORMAT );
		if( timestampFormat == null )	{
			timestampFormat = "yyyy/MM/dd hh:mm";
			Logger.warn( MessageIDs.SAV0017W, new Object[]{"\"" + timestampFormat + "\""} );
		}
		_timestampFormat = new SimpleDateFormat( timestampFormat );

		_nodataTitle = (String)resources.getResource( ResourceIDs.CELL_NO_DATA_TITLE );
		if( _nodataTitle == null )	{
			_nodataTitle = "-NO DATA-";
			Logger.warn( MessageIDs.SAV0018W, new Object[]{"\"" + _nodataTitle + "\""} );
		}
	}


//
//	JComponent ̎
//
	public void paintComponent( Graphics g )
	{
		Dimension	size = getSize();
		if( _selected )	{
			g.setColor( _selectedBackground );
		}
		else	{
			g.setColor( _unselectedBackground );
		}
		g.fillRect( 0, 0, size.width, size.height );

		g.setColor( Color.black );

		Graphics2D	g2 = (Graphics2D)g;
		g2.setRenderingHint( RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON );
		float	y = 3f;
		AttributedString	as = null;
		TextLayout	layout = null;

		if( _info == null )	{
			as = new AttributedString( _titleFormat.format(new Object[]{String.valueOf(_index + 1), _nodataTitle}) );
			as.addAttribute( TextAttribute.FONT, _titleFont );
			as.addAttribute( TextAttribute.FOREGROUND, _titleColor );

			layout = new TextLayout( as.getIterator(), g2.getFontRenderContext() );
			layout.draw( g2, 5, layout.getAscent() + y );
			y += layout.getAscent() + layout.getDescent() + 5f;
		}
		else	{
			as = new AttributedString( _titleFormat.format(new Object[]{String.valueOf(_index + 1), _info.getTitle()}) );
			as.addAttribute( TextAttribute.FONT, _titleFont );
			as.addAttribute( TextAttribute.FOREGROUND, _titleColor );

			layout = new TextLayout( as.getIterator(), g2.getFontRenderContext() );
			layout.draw( g2, 5, layout.getAscent() + y );
			y += layout.getAscent() + layout.getDescent() + 5f;

			as = new AttributedString( _timestampFormat.format(_info.getTimestamp()) );
			as.addAttribute( TextAttribute.FONT, _timestampFont );
			as.addAttribute( TextAttribute.FOREGROUND, _timestampColor );

			layout = new TextLayout( as.getIterator(), g2.getFontRenderContext() );
			layout.draw( g2, 5, layout.getAscent() + y );
			y += layout.getAscent() + layout.getDescent() + 5f;

			if( _info.getComment() != null )	{
				as = new AttributedString( _info.getComment() );
				as.addAttribute( TextAttribute.FONT, _commentFont );
				as.addAttribute( TextAttribute.FOREGROUND, _commentColor );

				layout = new TextLayout( as.getIterator(), g2.getFontRenderContext() );
				layout.draw( g2, 5, layout.getAscent() + y );
			}
		}
	}


//
//	ListCellRenderer ̎
//
	public Component getListCellRendererComponent( JList list, Object value, int index, boolean isSelected, boolean cellHasForcus )
	{
		_info = (SaveDataInfo)value;
		_selected = isSelected;
		_index = index;
		setBorder( BorderFactory.createEtchedBorder(javax.swing.border.EtchedBorder.LOWERED) );
		return this;
	}
}
