/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: WaitHandler.java,v 1.1.2.1 2003/12/11 10:17:57 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario.util;

import	org.xml.sax.Attributes;

import	tsukuba_bunko.peko.ActionControler;
import	tsukuba_bunko.peko.Logger;
import	tsukuba_bunko.peko.PekoSystem;

import	tsukuba_bunko.peko.scenario.ElementHandler;
import	tsukuba_bunko.peko.scenario.PSMLUtil;


/**
 * <samp>wait</samp> vf ElementHandler łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class WaitHandler	extends ElementHandler	{

	/**
	 * <code>WaitHandler</code> ̃CX^X쐬܂B
	 */
	public WaitHandler()
	{
		super();
	}


//
//	ContentHandler ̎
//
	public void startDocument()
	{
		ActionControler	controler = PekoSystem.getInstance().getActionControler();
		controler.setSaveEnabled( true );
	}

	public void endDocument()
	{
		ActionControler	controler = PekoSystem.getInstance().getActionControler();
		controler.setSaveEnabled( false );
	}

	public void startElement( String namespaceURI, String localName, String qName, Attributes attrs )
	{
		ActionControler	controler = PekoSystem.getInstance().getActionControler();

		String	dur = PSMLUtil.getAttributeValue( attrs, "dur" );
		if( dur == null )	{
			controler.stop();
		}
		else	{
			try	{
				controler.stop( Long.parseLong(dur) );
			}
			catch( NumberFormatException nfe )	{
				Logger.warn( MessageIDs.SCN6001W, new Object[]{getSceneContext().getCurrentPath()}, nfe );
				controler.stop();
			}
		}
	}
}
