/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: ElementHandler.java,v 1.1.2.1 2003/12/11 10:13:39 ppoi Exp $
 */
package tsukuba_bunko.peko.scenario;

import	org.xml.sax.Attributes;
import	org.xml.sax.SAXException;

import	tsukuba_bunko.peko.PekoSystem;


/**
 * PSML Scene vfnh̊{@\`܂B
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public abstract class ElementHandler	{

	/**
	 * PSML 1.0 "Scene" XML Namespace URI
	 */
	public static final String	NAMESPACE_SCENE = "http://tsukuba-bunko.org/ns/psml-scene";

	/**
	 * V[ReNXg
	 */
	protected SceneContext	_context = null;

	/**
	 * evf̃nh
	 */
	protected ElementHandler	_parent = null;

	/**
	 * V[̗vf̏ȂďI邩ǂ
	 */
	protected boolean	_endOfScene = false;


	/**
	 * <code>ElementHandler</code> ̃CX^X𐶐܂B
	 */
	protected ElementHandler()
	{
		super();
	}

	/**
	 * V[ReNXgݒ肵܂B
	 * @param	context	V[ReNXg
	 */
	public void setSceneContext( SceneContext context )
	{
		_context = context;
	}

	/**
	 * V[ReNXg擾܂B
	 * @return	V[ReNXg
	 */
	public SceneContext getSceneContext()
	{
		return _context;
	}

	/**
	 * evfĂ ElementHandler ݒ肵܂B
	 * @param	handler	evf̃nh
	 */
	public void setParentHandler( ElementHandler handler )
	{
		_parent = handler;
	}

	/**
	 * evfĂ ElementHandler 擾܂B
	 * @return	evf̃nh
	 */
	public ElementHandler getParentHandler()
	{
		return _parent;
	}

	/**
	 * V[̗vf̏ȂďI邩ǂݒ肵܂B
	 * @param	end	V[Iꍇ <code>true</code>AȊȌꍇ <code>false</code>
	 */
	protected void setEndOfScene( boolean end )
	{
		_endOfScene = end;
	}

	/**
	 * V[̗vf̏ȂďI邩ǂ𔻒肵܂B
	 * @return	V[Iꍇ <code>true</code>AȊȌꍇ <code>false</code>
	 */
	public boolean isEndOfScene()
	{
		return _endOfScene;
	}

	/**
	 * ꎞ~܂B
	 * @param	wait	ő~
	 */
	protected void stop( long wait )
	{
		if( _context != null )	{
			if( _context.getSceneProcessor().isAborted() )	{
				return;
			}
			tsukuba_bunko.peko.Logger.debug( "[scenario.handler] stop using ElementHandler#stop(wait)." );
			PekoSystem.getInstance().getActionControler().stop( wait );
		}
	}

	/**
	 * [U[̃ANV܂ňꎞ~܂B
	 */
	protected void stop()
	{
		if( _context != null )	{
			if( _context.getSceneProcessor().isAborted() )	{
				return;
			}
			tsukuba_bunko.peko.Logger.debug( "[scenario.handler] stop using ElementHandler#stop()." );
			PekoSystem.getInstance().getActionControler().stop();
		}
	}


//
//	SAX ContentHandler
//
	public void startDocument()
		throws SAXException
	{
	}

	public void endDocument()
		throws SAXException
	{
	}

	public void startElement( String namespaceURI, String localName, String qName, Attributes attrs )
		throws SAXException
	{
	}

	public void endElement( String namespaceURI, String localName, String qName )
		throws SAXException
	{
	}

	public void characters( char[] ch, int begin, int length )
		throws SAXException
	{
	}
}