/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: ResourceManager.java,v 1.3.2.1 2003/12/11 11:11:53 ppoi Exp $
 */
package tsukuba_bunko.peko.resource;

import	java.net.URL;

import	tsukuba_bunko.resource.DeserializerMapping;
import	tsukuba_bunko.resource.Resources;

import	tsukuba_bunko.peko.InitializationError;
import	tsukuba_bunko.peko.Logger;


/**
 * "Peko" gp郊\[XǗ@\񋟂܂B
 * @author	$Author: ppoi $
 * @version	$Revision: 1.3.2.1 $
 */
public class ResourceManager	{

	/**
	 * ObZ[Wi[t@C
	 */
	protected static final String	RES_MESSAGE = "messages.xml";

	/**
	 * VXe\\[Xi[t@C
	 */
	protected static final String	RES_SYSTEM = "system.xml";

	/**
	 * j[ڃ\[Xi[t@C
	 */
	protected static final String	RES_MENU = "menu.xml";

	/**
	 * _CAO\\[Xi[t@C
	 */
	protected static final String	RES_DIALOG = "dialog.xml";

	/**
	 * LoX\\[Xi[t@C
	 */
	protected static final String	RES_CANVAS = "canvas.xml";

	/**
	 * Q[\\[Xi[t@C
	 */
	protected static final String	RES_GAME ="game-info.xml";

	/**
	 * ^Cgʍ\\[Xi[t@C
	 */
	protected static final String	RES_TITLE = "title.xml";


	/**
	 * B̃CX^X
	 */
	private static ResourceManager	_instance = null;


	/**
	 * \[X[_
	 */
	private PekoResourceLoader	_loader = null;


	/**
	 * \[X
	 */
	private Resources	_resources = null;

	/**
	 * P[V\[X
	 */
	private LocationResources	_locationResources = null;


	/**
	 * <code>ResourceManager</code> ̃CX^X쐬܂B
	 */
	protected ResourceManager()
	{
		super();
	}


	/**
	 * \[X݂邩ǂ𔻒肵܂B
	 * @param	resourceID	\[X ID
	 * @return	݂ꍇ <code>true</code>A݂Ȃꍇ <code>false</code>
	 */
	public boolean exists( String resourceID )
	{
		return (_resources.getResource(resourceID) != null);
	}

	/**
	 * \[X擾܂B
	 * @param	resourceID	\[X ID
	 * @return	\[XBΉ郊\[X݂Ȃꍇ <code>null</code>B
	 */
	public Object getResource( String resourceID )
	{
		return getResource( resourceID, false );
	}

	/**
	 * \[X擾܂B
	 * @param	resourceID	\[X ID
	 * @param	nowarn	<code>true</code> ̏ꍇA[jOOo͂Ȃ
	 * @return	\[XBΉ郊\[X݂Ȃꍇ <code>null</code>B
	 */
	public Object getResource( String resourceID, boolean nowarn )
	{
		Object	resource = _resources.getResource( resourceID );
		if( !nowarn )	{
			if( resource == null )	{
				Logger.warn( MessageIDs.RES0001W.getMessage( new Object[]{resourceID} ) );
			}
		}
		return resource;
	}

	/**
	 * P[V\[X擾܂B
	 * @return	P[V\[X
	 */
	public LocationResources getLocationResources()
	{
		return _locationResources;
	}


	/**
	 * \[X[_擾܂B
	 * @return	\[X[_
	 */
	private PekoResourceLoader getResourceLoader()
	{
		try	{
			if( _loader == null )	{
				_loader = new PekoResourceLoader();
			}
			return _loader;
		}
		catch( Exception e )	{
			InitializationError	ie = new InitializationError( "fail to create instance of PekoResourceLoader", e );
			Logger.fatal( MessageIDs.RES0014F, e );
			throw ie;
		}
	}

	/**
	 * ObZ[Wǂݍ݂܂B
	 */
	private void loadLogMessages()
	{
		try	{
			URL	resourceURL = getClass().getClassLoader().getResource( ResourceManager.RES_MESSAGE );
			if( resourceURL == null )	{
				InitializationError	ie = new InitializationError( "missing resource file of log messgages." );
				Logger.fatal( "[RES9998F] missing resource file of log messgages.", ie );
				throw ie;
			}
			Logger.debug( "loading log messages from " + resourceURL.toString() );

			_resources = Resources.newInstance( resourceURL );
		}
		catch( Exception e )	{
			InitializationError	ie = new InitializationError( "fail to load resources of log messages.", e );
			Logger.fatal( "[RES9999F] fail to load resources of log messages.", ie );
			throw ie;
		}
	}

	/**
	 * VXe\\[Xǂݍ݂܂B
	 */
	private void loadSystemConfigurationResources()
	{
		try	{
			URL	resourceURL = getClass().getClassLoader().getResource( ResourceManager.RES_SYSTEM );
			if( resourceURL == null )	{
				InitializationError	ie = new InitializationError( "missing resource file of PVNS resource." );
				Logger.fatal( MessageIDs.RES0002F, new Object[]{ResourceManager.RES_SYSTEM}, ie );
				throw ie;
			}
			Logger.debug( "loadingresources of system configuration from " + resourceURL.toString() );

			PekoResourceLoader	loader = getResourceLoader();
			loader.loadResource( resourceURL, _resources );
		}
		catch( Exception e )	{
			InitializationError	ie = new InitializationError( "fail to load resources of system configuration", e );
			Logger.fatal( MessageIDs.RES0003F, new Object[]{ResourceManager.RES_SYSTEM}, ie );
			throw ie;
		}

		LocationConfigurator	configurator = new LocationConfigurator();
		_locationResources = configurator.configure( _resources );
	}

	/**
	 * j[ڍ\\[Xǂݍ݂܂B
	 */
	private void loadMenuResources()
	{
		try	{
			URL	resourceURL = getClass().getClassLoader().getResource( ResourceManager.RES_MENU );
			if( resourceURL == null )	{
				InitializationError	ie = new InitializationError( "missing resource file of menu items." );
				Logger.fatal( MessageIDs.RES0002F, new Object[]{ResourceManager.RES_MENU}, ie );
				throw ie;
			}
			Logger.debug( "loading resources of menu items from " + resourceURL.toString() );

			PekoResourceLoader	loader = getResourceLoader();
			loader.loadResource( resourceURL, _resources );
		}
		catch( Exception e )	{
			InitializationError	ie = new InitializationError( "fail to load resources of menu item configuration", e );
			Logger.fatal( MessageIDs.RES0003F, new Object[]{ResourceManager.RES_SYSTEM}, ie );
			throw ie;
		}
	}

	/**
	 * _CAO\\[Xǂݍ݂܂B
	 */
	private void loadDialogConfigurationResources()
	{
		try	{
			URL	resourceURL = getClass().getClassLoader().getResource( ResourceManager.RES_DIALOG );
			if( resourceURL == null )	{
				InitializationError	ie = new InitializationError( "missing resource file of dialog configuration." );
				Logger.fatal( MessageIDs.RES0002F, new Object[]{ResourceManager.RES_DIALOG}, ie );
				throw ie;
			}
			Logger.debug( "loading resources of dialog configuration from " + resourceURL.toString() );

			PekoResourceLoader	loader = getResourceLoader();
			loader.loadResource( resourceURL, _resources );
		}
		catch( Exception e )	{
			InitializationError	ie = new InitializationError( "fail to load resources of dialog configuration", e );
			Logger.fatal( MessageIDs.RES0003F, new Object[]{ResourceManager.RES_DIALOG}, ie );
			throw ie;
		}
	}

	/**
	 * LoX\\[Xǂݍ݂܂B
	 */
	private void loadCanvasConfigurationResources()
	{
		try	{
			URL	resourceURL = getClass().getClassLoader().getResource( ResourceManager.RES_CANVAS );
			if( resourceURL == null )	{
				InitializationError	ie = new InitializationError( "missing resource file of canvas configuration." );
				Logger.fatal( MessageIDs.RES0002F, new Object[]{ResourceManager.RES_CANVAS}, ie );
				throw ie;
			}
			Logger.debug( "loading resources of canvas configuration from " + resourceURL.toString() );

			PekoResourceLoader	loader = getResourceLoader();
			loader.loadResource( resourceURL, _resources );
		}
		catch( Exception e )	{
			InitializationError	ie = new InitializationError( "fail to load resources of canvas configuration", e );
			Logger.fatal( MessageIDs.RES0003F, new Object[]{ResourceManager.RES_CANVAS}, ie );
			throw ie;
		}
	}

	/**
	 * ^Cgʍ\\[Xǂݍ݂܂B
	 */
	private void loadTitleConfigurationResources()
	{
		try	{
			URL	resourceURL = getClass().getClassLoader().getResource( ResourceManager.RES_TITLE );
			if( resourceURL == null )	{
				InitializationError	ie = new InitializationError( "missing resource file of title configuration." );
				Logger.fatal( MessageIDs.RES0002F, new Object[]{ResourceManager.RES_TITLE}, ie );
				throw ie;
			}
			Logger.debug( "loading resources of title configuration from " + resourceURL.toString() );

			PekoResourceLoader	loader = getResourceLoader();
			loader.loadResource( resourceURL, _resources );
		}
		catch( Exception e )	{
			InitializationError	ie = new InitializationError( "fail to load resources of title configuration", e );
			Logger.fatal( MessageIDs.RES0003F, new Object[]{ResourceManager.RES_TITLE}, ie );
			throw ie;
		}
	}



	/**
	 * Q[񃊃\[Xǂݍ݂܂B
	 */
	private void loadGameInfoResources()
	{
		try	{
			URL	resourceURL = getClass().getClassLoader().getResource( ResourceManager.RES_GAME );
			if( resourceURL == null )	{
				InitializationError	ie = new InitializationError( "missing resource file of game information resource." );
				Logger.fatal( MessageIDs.RES0002F, new Object[]{ResourceManager.RES_GAME}, ie );
				throw ie;
			}
			Logger.debug( "loading game information resources from " + resourceURL.toString() );

			PekoResourceLoader	loader = getResourceLoader();

			DeserializerMapping	mapping = loader.getDeserializerMapping();
			IconDeserializer	deserializer = (IconDeserializer)mapping.getResourceDeserializer( "peko:icon" );
			deserializer.setBaseURL( _locationResources.getMiscDirecotryURL() );

			loader.loadResource( resourceURL, _resources );
		}
		catch( Exception e )	{
			InitializationError	ie = new InitializationError( "fail to load resources of game information resource", e );
			Logger.fatal( MessageIDs.RES0003F, new Object[]{ResourceManager.RES_GAME}, ie );
			throw ie;
		}
	}

	/**
	 * <code>ResourceManager</code> ̃CX^X܂B
	 * @throws	InitializationError	Ɏsꍇ
	 */
	private void initialize()
	{
		Logger.debug( "[resource] start initializing ResourceManager." );

		loadLogMessages();

		loadSystemConfigurationResources();
		loadMenuResources();
		loadDialogConfigurationResources();
		loadCanvasConfigurationResources();
		loadTitleConfigurationResources();

		loadGameInfoResources();

		Logger.debug( "[resource] finish initializing ResourceManager." );
	}


	/**
	 * <code>ResourceManager</code> ̗B̃CX^X擾܂B
	 * @return	B <code>ResourceManager</code> ̃CX^X
	 */
	public static ResourceManager getInstance()
	{
		if( _instance == null )	{
			synchronized( ResourceManager.class )	{
				if( _instance == null )	{
					_instance = new ResourceManager();
					_instance.initialize();
				}
			}
		}
		return _instance;
	}
}