/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: PointDeserializer.java,v 1.1.2.1 2003/12/11 11:11:53 ppoi Exp $
 */
package tsukuba_bunko.peko.resource;

import	java.awt.Point;

import	org.xml.sax.SAXException;

import	tsukuba_bunko.resource.SimpleDeserializer;


/**
 * {@link java.awt.Point} ^̃\[Xɑ΂ {@link tsukuba_bunko.resource.ResourceDeserializer} łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 * @see <a href="http://softlab.tsukuba-bunko.org/peko/userguide/resource.html#type-peko:point">peko:point ^̃\[X</a>
 */
public class PointDeserializer	extends SimpleDeserializer	{

	/**
	 * <code>DimensionDeserializer</code> ̃CX^X쐬܂B
	 */
	public PointDeserializer()
	{
		super();
	}


//
//	SimpleDeserializer ̎
//
	protected Object convertValue( String source )
		throws SAXException
	{
		try	{
			return PointDeserializer.parsePoint( source );
		}
		catch( Exception e )	{
			throw new SAXException( e );
		}
	}


	/**
	 * <code>source</code>  Dimension Ƃĉ͂܂B
	 * @param	source	͌̕
	 * @return	͌
	 */
	public static Point parsePoint( String source )
		throws IllegalArgumentException
	{
		try	{
			int	delm = source.indexOf( ',' );
			int	x = Integer.parseInt( source.substring(0, delm).trim() );
			int	y = Integer.parseInt( source.substring(delm + 1).trim() );
			return new Point( x, y );
		}
		catch( Exception e )	{
			throw new IllegalArgumentException( e.getMessage() );
		}
	}
}
