/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: PekoResourceLoader.java,v 1.1.2.1 2003/12/11 11:11:53 ppoi Exp $
 */
package tsukuba_bunko.peko.resource;

import	javax.xml.parsers.ParserConfigurationException;

import	org.xml.sax.Attributes;
import	org.xml.sax.SAXException;

import	tsukuba_bunko.resource.ResourceDeserializer;
import	tsukuba_bunko.resource.ResourceLoader;


/**
 * "Peko" p̃\[X[h ResouceLoader łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 */
public class PekoResourceLoader	extends ResourceLoader	{

	/**
	 * pX
	 */
	private StringBuffer	_path = null;


	/**
	 * <code>PekoResourceLoader</code> ̃CX^X쐬܂B
	 * @throws	InitializationError	Ɏsꍇ
	 */
	public PekoResourceLoader()
		throws ParserConfigurationException, SAXException
	{
		super();
		setDeserializerMapping( TypeMapping.getInstance().getDeserializerMapping() );
	}


//
//	ResourceLoader ̎
//
	protected ResourceDeserializer getResourceDeserializer( String namespaceURI, String localName, String qName, Attributes attrs )
	{
		ResourceDeserializer	deserializer = null;

		if( (_path == null) || (_path.length() == 0) )	{
			_path = new StringBuffer( getCurrentPath() );
		}
		else	{
			_path.append( '.' );
			_path.append( qName );
		}

		TypeMapping	mapping = TypeMapping.getInstance();
		deserializer = mapping.getResourceDeserializer( new String(_path) );
		return deserializer;
	}


//
//	ContentHandler ̎
//
	public void startDocument()
	{
		super.startDocument();
		_path = null;
	}

	public void endElement( String namespaceURI, String localName, String qName )
		throws SAXException
	{
		super.endElement( namespaceURI, localName, qName );
		_path = null;
	}
}
