/*
 * "Peko" Visual Novel System
 *
 * All Rights Reserved.
 * Copyright (c) 1999-2003 Tsukuba Bunko.
 *
 * $Id: LocaleDeserializer.java,v 1.1.2.1 2003/12/11 11:11:53 ppoi Exp $
 */
package tsukuba_bunko.peko.resource;

import	java.util.Locale;

import	org.xml.sax.Attributes;

import tsukuba_bunko.resource.BasicDeserializer;


/**
 * {@link java.util.Locale} ^̃\[Xɑ΂ {@link tsukuba_bunko.resource.ResourceDeserializer} łB
 * @author	$Author: ppoi $
 * @version	$Revision: 1.1.2.1 $
 * @see <a href="http://softlab.tsukuba-bunko.org/peko/userguide/resource.html#type-peko:locale">peko:locale ^̃\[X</a>
 */
public class LocaleDeserializer extends BasicDeserializer {

	/**
	 * eLXg
	 */
	private StringBuffer	_text = null;

	/**
	 * R[h
	 */
	private String	_country = null;

	/**
	 * R[h
	 */
	private String	_language = null;


	/**
	 * <code>LocaleDeserializer</code> ̃CX^X𐶐܂B
	 */
	public LocaleDeserializer()
	{
		super();
	}


//
//	ContentHandler ̎
//
	public void startDocument()
	{
		_country = null;
		_language = null;
	}

	public void endDocument()
	{
		if( _language != null )	{
			if( _country != null )	{
				setValue( new Locale(_language, _country) );
			}
			else	{
				setValue( new Locale(_language) );
			}
		}
		else	{
			setValue( Locale.getDefault() );
		}
	}

	public void startElement( String namespaceURI, String localName, String qName, Attributes attrs )
	{
		if( "language".equals(localName) || "country".equals(localName) )	{
			_text = new StringBuffer();
		}
	}

	public void endElement( String namespaceURI, String localName, String qName )
	{
		if( "language".equals(localName) )	{
			String	language = new String(_text).trim();
			if( language.length() > 0 )	{
				_language = language;
			}
		}
		else if( "country".equals(localName) )	{
			String	country = new String(_text).trim();
			if( country.length() > 0 )	{
				_country = country;
			}
		}
		_text = null;
	}

	public void characters( char[] ch, int begin, int length )
	{
		if( _text != null )	{
			_text.append( ch, begin, length );
		}
	}
}