/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.util.locator;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import tsukuba_bunko.util.ResourceDetectionException;
import tsukuba_bunko.util.ResourceLocator;

public class ResourceLocatorImpl
extends ResourceLocator {
    public File findLocation(String resourceName, ClassLoader classLoader) throws ResourceDetectionException {
        URL resourceURL = classLoader.getResource(resourceName);
        if (resourceURL == null) {
            throw new ResourceDetectionException("fail to find resource from classpath");
        }
        String protocol = resourceURL.getProtocol();
        if ("file".equals(protocol)) {
            String path = resourceURL.getFile();
            try {
                path = URLDecoder.decode(path, "UTF-8");
            }
            catch (UnsupportedEncodingException uee) {
                throw new ResourceDetectionException("system is not supoort UTF-8. This Java VM may be broken.", uee);
            }
            int index = path.indexOf(resourceName);
            if (index > 0) {
                resourceName = resourceName.substring(0, index);
            }
            return new File(resourceName);
        }
        if ("jar".equals(protocol)) {
            String jarUri = resourceURL.toString();
            int delemiterIndex = jarUri.indexOf("!/");
            if (delemiterIndex == -1) {
                throw new ResourceDetectionException("invalid JAR URL.");
            }
            String resourceUri = jarUri.substring(4, delemiterIndex);
            if (!resourceUri.startsWith("file:")) {
                throw new ResourceDetectionException("supported file protocol only");
            }
            try {
                return new File(URLDecoder.decode(new URL(resourceUri).getFile(), "UTF-8"));
            }
            catch (Exception e) {
                throw new ResourceDetectionException("invalid URL.", e);
            }
        }
        throw new ResourceDetectionException("supported jar or file protocol only");
    }
}

