/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.resource;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import tsukuba_bunko.resource.DeserializerMapping;
import tsukuba_bunko.resource.IllegalResourceException;
import tsukuba_bunko.resource.ResourceDeserializer;
import tsukuba_bunko.resource.Resources;

public class ResourceLoader
implements ContentHandler {
    private XMLReader _parser = null;
    private DeserializerMapping _mapping = DeserializerMapping.newInstance();
    private ResourceDeserializer _currentDeserializer = null;
    private int _level = 0;
    private List _stack = null;
    private StringBuffer _text = null;
    private Resources _resources = null;

    public ResourceLoader() throws ParserConfigurationException, SAXException {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(true);
        this._parser = factory.newSAXParser().getXMLReader();
        this._parser.setContentHandler(this);
    }

    public void setDeserializerMapping(DeserializerMapping mapping) {
        this._mapping = mapping;
    }

    public DeserializerMapping getDeserializerMapping() {
        return this._mapping;
    }

    public void loadResource(URL resourceURL, Resources resources) throws IOException, IllegalResourceException {
        try {
            this._resources = resources;
            this._parser.parse(resourceURL.toString());
            this._resources = null;
        }
        catch (SAXException se) {
            throw new IllegalResourceException(se);
        }
    }

    protected ResourceDeserializer getResourceDeserializer(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        if (this._mapping == null) {
            return null;
        }
        String dataType = attrs.getValue("type");
        if (dataType != null) {
            ResourceDeserializer deserializer = this._mapping.getResourceDeserializer(dataType);
            if (deserializer == null) {
                throw new SAXException("no deserializer for \"" + dataType + "\"");
            }
            return deserializer;
        }
        return null;
    }

    protected String getCurrentPath() {
        StringBuffer buffer = new StringBuffer();
        Iterator itr = this._stack.iterator();
        if (itr.hasNext()) {
            itr.next();
        }
        if (itr.hasNext()) {
            buffer.append(itr.next());
        }
        while (itr.hasNext()) {
            buffer.append(".");
            buffer.append(itr.next());
        }
        return new String(buffer);
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void startPrefixMapping(String namespaceURI, String prefix) throws SAXException {
        if (this._currentDeserializer != null) {
            this._currentDeserializer.startPrefixMapping(namespaceURI, prefix);
        }
    }

    public void endPrefixMapping(String namespaceURI) throws SAXException {
        if (this._currentDeserializer != null) {
            this._currentDeserializer.endPrefixMapping(namespaceURI);
        }
    }

    public void startDocument() {
        this._stack = new ArrayList();
        if (this._mapping == null) {
            this._mapping = DeserializerMapping.newInstance();
        }
    }

    public void endDocument() {
        this._stack = null;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        if (this._currentDeserializer != null) {
            ++this._level;
            this._currentDeserializer.startElement(namespaceURI, localName, qName, attrs);
        } else {
            this._stack.add(qName);
            ResourceDeserializer deserializer = this.getResourceDeserializer(namespaceURI, localName, qName, attrs);
            if (deserializer != null) {
                this._currentDeserializer = deserializer;
                deserializer.setDeserializerMapping(this._mapping);
                ++this._level;
                deserializer.startDocument();
                deserializer.startElement(namespaceURI, localName, qName, attrs);
            } else {
                this._text = new StringBuffer();
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        if (this._currentDeserializer != null) {
            --this._level;
            this._currentDeserializer.endElement(namespaceURI, localName, qName);
            if (this._level == 0) {
                this._currentDeserializer.endDocument();
                this._resources.setResource(this.getCurrentPath(), this._currentDeserializer.getValue());
                this._stack.remove(this._stack.size() - 1);
                this._currentDeserializer = null;
                this._currentDeserializer = null;
            }
        } else if (this._text != null) {
            this._resources.setResource(this.getCurrentPath(), new String(this._text));
            this._stack.remove(this._stack.size() - 1);
        } else {
            this._stack.remove(this._stack.size() - 1);
        }
        this._text = null;
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this._currentDeserializer != null) {
            this._currentDeserializer.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this._currentDeserializer != null) {
            this._currentDeserializer.skippedEntity(name);
        }
    }

    public void characters(char[] ch, int begin, int length) throws SAXException {
        if (this._currentDeserializer != null) {
            this._currentDeserializer.characters(ch, begin, length);
        } else if (this._text != null) {
            this._text.append(ch, begin, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int begin, int length) throws SAXException {
        if (this._currentDeserializer != null) {
            this._currentDeserializer.ignorableWhitespace(ch, begin, length);
        }
    }
}

