/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.resource;

import java.util.ArrayList;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import tsukuba_bunko.resource.BasicDeserializer;
import tsukuba_bunko.resource.ResourceDeserializer;

public class ListDeserializer
extends BasicDeserializer {
    private List _list = null;
    private ResourceDeserializer _itemDeserializer = null;
    private ContentHandler _itemHandler = null;
    private String _itemType = null;
    private int _level = 0;

    public void setTypeName(String typeName) {
        super.setTypeName(typeName);
        int index = typeName.indexOf(47);
        if (index == -1) {
            throw new IllegalArgumentException("illegal list item type. \"" + typeName + "\"");
        }
        this._itemType = typeName.substring(index + 1);
    }

    public void startDocument() {
        this._list = null;
        this._level = 0;
    }

    public void endDocument() {
        this.setValue(this._list);
        this._list = null;
    }

    public void startPrefixMapping(String namespaceURI, String prefix) throws SAXException {
        if (this._itemHandler != null) {
            this._itemHandler.startPrefixMapping(namespaceURI, prefix);
        }
    }

    public void endPrefixMapping(String namespaceURI) throws SAXException {
        if (this._itemHandler != null) {
            this._itemHandler.endPrefixMapping(namespaceURI);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        if (this._list == null) {
            this._list = new ArrayList();
            this._itemDeserializer = this._mapping.getResourceDeserializer(this._itemType);
            if (this._itemDeserializer != null) return;
            throw new SAXException("no deserializer for \"" + this._itemType + "\"");
        }
        if (this._itemHandler == null) {
            if (!localName.equals("item")) throw new SAXException("illegal structure. : non-item element \"" + qName + "\"");
            ++this._level;
            this._itemHandler = this._itemDeserializer;
            this._itemHandler.startElement(namespaceURI, localName, qName, attrs);
            return;
        } else {
            ++this._level;
            this._itemHandler.startElement(namespaceURI, localName, qName, attrs);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            if (this._itemHandler != null) {
                --this._level;
                this._itemHandler.endElement(namespaceURI, localName, qName);
                if (this._level == 0) {
                    this._list.add(this._itemDeserializer.getValue());
                    this._itemHandler = null;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        if (this._itemHandler != null) {
            this._itemHandler.processingInstruction(target, data);
        }
    }

    public void skippedEntity(String name) throws SAXException {
        if (this._itemHandler != null) {
            this._itemHandler.skippedEntity(name);
        }
    }

    public void characters(char[] ch, int begin, int length) throws SAXException {
        if (this._itemHandler != null) {
            this._itemHandler.characters(ch, begin, length);
        }
    }

    public void ignorableWhitespace(char[] ch, int begin, int length) throws SAXException {
        if (this._itemHandler != null) {
            this._itemHandler.ignorableWhitespace(ch, begin, length);
        }
    }
}

