/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.session;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.DecimalFormat;
import java.util.Date;
import java.util.HashSet;
import javax.swing.JOptionPane;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.session.LoadFailureException;
import tsukuba_bunko.peko.session.MessageIDs;
import tsukuba_bunko.peko.session.SaveData;
import tsukuba_bunko.peko.session.SaveDataDialog;
import tsukuba_bunko.peko.session.SaveDataInfo;
import tsukuba_bunko.peko.session.SaveFailureException;
import tsukuba_bunko.peko.session.Session;
import tsukuba_bunko.peko.session.SystemSaveData;

public class SessionManager {
    protected static final DecimalFormat FORMAT = new DecimalFormat("000");
    protected int _lastIndex = -1;
    protected SystemSaveData _systemSaveData = null;
    protected Session _session = null;

    public SessionManager() {
        try {
            this._systemSaveData = this.loadSystemSaveData();
        }
        catch (Exception e) {
            Logger.debug("[session.manager] fail to load SystemSaveData.", e);
        }
        this._session = new Session();
        this._session.setSessionFlagSet(new HashSet(89));
        if (this._systemSaveData != null) {
            this._session.setSystemFlagSet(this._systemSaveData.getSystemFlagSet(), this._systemSaveData.getSaveDataInfo().getTimestamp());
        } else {
            this._systemSaveData = new SystemSaveData();
            SaveDataInfo info = new SaveDataInfo();
            info.setID(-1);
            info.setTitle("PVNS System Save Data");
            this._systemSaveData.setSaveDataInfo(info);
            this._session.setSystemFlagSet(new HashSet(89), null);
        }
    }

    public void initializeSession() {
        this._session.setSessionFlagSet(new HashSet(89));
        this._session.setSceneContext(null);
    }

    public Session getSession() {
        return this._session;
    }

    public SystemSaveData getSystemSaveData() {
        return this._systemSaveData;
    }

    public void saveCurrentSession() throws SaveFailureException {
        SaveData saveData = new SaveData();
        SaveDataInfo saveDataInfo = new SaveDataInfo();
        saveDataInfo.setTitle(this._session.getSceneContext().getSceneTitle());
        saveData.setSaveDataInfo(saveDataInfo);
        saveData.setSession(this._session);
        this.save(saveData);
    }

    protected SaveDataInfo[] getSaveDataInfoList(int beginIndex, int size) {
        SaveDataInfo[] list = new SaveDataInfo[size];
        File saveFile = null;
        SaveData saveData = null;
        SaveDataInfo saveDataInfo = null;
        Object data = null;
        FileInputStream fis = null;
        ObjectInputStream ois = null;
        int i = 0;
        while (i < list.length) {
            saveFile = this.getSaveFile(i + beginIndex);
            if (saveFile.isFile()) {
                Exception e3;
                Object var12_12;
                try {
                    try {
                        fis = new FileInputStream(saveFile);
                        ois = new ObjectInputStream(fis);
                        data = ois.readObject();
                    }
                    catch (Exception e2) {
                        Logger.warn(MessageIDs.SAV0008W, new Object[]{String.valueOf(i + beginIndex)}, e2);
                    }
                }
                catch (Throwable throwable) {
                    var12_12 = null;
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Exception e3) {
                            Logger.warn(MessageIDs.SAV0004W, (Throwable)e3);
                        }
                    } else if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception e3) {
                            Logger.warn(MessageIDs.SAV0004W, (Throwable)e3);
                        }
                    }
                    ois = null;
                    fis = null;
                    throw throwable;
                }
                var12_12 = null;
                if (ois != null) {
                    try {
                        ois.close();
                    }
                    catch (Exception e3) {
                        Logger.warn(MessageIDs.SAV0004W, (Throwable)e3);
                    }
                } else if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (Exception e3) {
                        Logger.warn(MessageIDs.SAV0004W, (Throwable)e3);
                    }
                }
                ois = null;
                fis = null;
                if (data instanceof SaveData) {
                    saveData = (SaveData)data;
                    if (saveData != null) {
                        saveDataInfo = saveData.getSaveDataInfo();
                        if (saveDataInfo != null && saveDataInfo.getTitle() != null && saveDataInfo.getTimestamp() != null) {
                            list[i] = saveDataInfo;
                        }
                    } else {
                        Logger.warn(MessageIDs.SAV0022W, new Object[]{String.valueOf(i)});
                    }
                }
            }
            ++i;
        }
        return list;
    }

    protected void save(SaveData data) throws SaveFailureException {
        block17: {
            FileOutputStream fos;
            block16: {
                SaveDataInfo[] list = this.getSaveDataInfoList(0, 20);
                int index = SaveDataDialog.showDialog(list, this.getInitialSelectedIndexForSave(list), true);
                Logger.debug("index: " + index);
                if (index == -1) {
                    return;
                }
                data.getSaveDataInfo().setID(index);
                Date timestamp = new Date();
                data.getSaveDataInfo().setTimestamp(timestamp);
                fos = null;
                ObjectOutputStream oos = null;
                try {
                    try {
                        File path = this.getSaveFile(data.getSaveDataInfo().getID());
                        Logger.debug("save to " + path.getAbsolutePath());
                        fos = new FileOutputStream(path);
                        oos = new ObjectOutputStream(fos);
                        oos.writeObject(data);
                        oos.flush();
                        this._lastIndex = index;
                    }
                    catch (Exception e) {
                        Logger.error(MessageIDs.SAV0001E, new Object[]{String.valueOf(data.getSaveDataInfo().getID())}, e);
                        SaveFailureException sfe = new SaveFailureException("fail to save.", e);
                        throw sfe;
                    }
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (Exception e) {
                            Logger.warn(MessageIDs.SAV0002W, (Throwable)e);
                        }
                    } else if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception e) {
                            Logger.warn(MessageIDs.SAV0002W, (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                Object var9_12 = null;
                if (oos == null) break block16;
                try {
                    oos.close();
                }
                catch (Exception e) {
                    Logger.warn(MessageIDs.SAV0002W, (Throwable)e);
                }
                break block17;
            }
            if (fos == null) break block17;
            try {
                fos.close();
            }
            catch (Exception e) {
                Logger.warn(MessageIDs.SAV0002W, (Throwable)e);
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean load() throws LoadFailureException {
        block20: {
            list = this.getSaveDataInfoList(0, 20);
            nodata = false;
            if (list != null) {
                nodata = true;
                i = 0;
                while (i < list.length) {
                    if (list[i] != null) {
                        nodata = false;
                    }
                    ++i;
                }
            } else {
                nodata = true;
            }
            if (nodata) {
                resources = ResourceManager.getInstance();
                title = (String)resources.getResource("peko.savedata-chooser.dialog.notify-nodata.title");
                if (title == null) {
                    Logger.warn(MessageIDs.SAV0020W);
                }
                if ((message = (String)resources.getResource("peko.savedata-chooser.dialog.notify-nodata.message")) == null) {
                    message = "No save data for loading.";
                    Logger.warn(MessageIDs.SAV0021W, new Object[]{"\"" + message + "\""});
                }
                JOptionPane.showMessageDialog(PekoSystem.getInstance().getMainWindow(), message, title, 1);
                return false;
            }
            index = SaveDataDialog.showDialog(list, this.getInitialSelectedIndexForLoad(list), false);
            if (index == -1) {
                return false;
            }
            path = this.getSaveFile(index);
            if (!path.exists()) {
                Logger.error(MessageIDs.SAV0005E, new Object[]{String.valueOf(index)});
                lfe = new LoadFailureException("no such save file");
                throw lfe;
            }
            fis = null;
            ois = null;
            try {
                try {
                    fis = new FileInputStream(path);
                    ois = new ObjectInputStream(fis);
                    data = (SaveData)ois.readObject();
                    session = data.getSession();
                    session.setSystemFlagSet(this._session.getSystemFlagSet(), this._session.getTimestamp());
                    this._session = session;
                    this._lastIndex = index;
                    var9_15 = null;
                    if (ois == null) break block20;
                }
                catch (Exception e) {
                    Logger.error(MessageIDs.SAV0003E, new Object[]{String.valueOf(String.valueOf(index))}, e);
                    lfe = new LoadFailureException("fail to load.", e);
                    throw lfe;
                }
            }
            catch (Throwable var10_21) {
                var9_16 = null;
                if (ois != null) {
                    try {
                        ois.close();
                        throw var10_21;
                    }
                    catch (Exception e) {
                        Logger.warn(MessageIDs.SAV0004W, (Throwable)e);
                        throw var10_21;
                    }
                }
                if (fis == null) throw var10_21;
                try {
                    fis.close();
                    throw var10_21;
                }
                catch (Exception e) {
                    Logger.warn(MessageIDs.SAV0004W, (Throwable)e);
                    throw var10_21;
                }
            }
            try {}
            catch (Exception e) {
                Logger.warn(MessageIDs.SAV0004W, (Throwable)e);
                return true;
            }
            ois.close();
            return true;
        }
        if (fis == null) return true;
        ** try [egrp 3[TRYBLOCK] [3 : 376->384)] { 
lbl77:
        // 1 sources

        fis.close();
        return true;
lbl79:
        // 1 sources

        catch (Exception e) {
            Logger.warn(MessageIDs.SAV0004W, (Throwable)e);
        }
        return true;
    }

    public void saveSystemSaveData() throws SaveFailureException {
        block16: {
            FileOutputStream fos;
            block15: {
                Logger.debug("save SystemSaveData.");
                SystemSaveData data = this._systemSaveData;
                data.setSystemFlagSet(this._session.getSystemFlagSet());
                fos = null;
                ObjectOutputStream oos = null;
                try {
                    try {
                        data.getSaveDataInfo().setTimestamp(new Date());
                        File path = this.getSystemSaveFile();
                        fos = new FileOutputStream(path);
                        oos = new ObjectOutputStream(fos);
                        oos.writeObject(data);
                        oos.flush();
                    }
                    catch (Exception e) {
                        Logger.error(MessageIDs.SAV0006F, (Throwable)e);
                        SaveFailureException sfe = new SaveFailureException("fail to save system save data.", e);
                        throw sfe;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    if (oos != null) {
                        try {
                            oos.close();
                        }
                        catch (Exception e) {
                            Logger.warn(MessageIDs.SAV0002W, (Throwable)e);
                        }
                    } else if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (Exception e) {
                            Logger.warn(MessageIDs.SAV0002W, (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                Object var6_9 = null;
                if (oos == null) break block15;
                try {
                    oos.close();
                }
                catch (Exception e) {
                    Logger.warn(MessageIDs.SAV0002W, (Throwable)e);
                }
                break block16;
            }
            if (fos == null) break block16;
            try {
                fos.close();
            }
            catch (Exception e) {
                Logger.warn(MessageIDs.SAV0002W, (Throwable)e);
            }
        }
    }

    public SystemSaveData loadSystemSaveData() throws LoadFailureException {
        SystemSaveData saveData;
        block17: {
            FileInputStream fis;
            block16: {
                saveData = null;
                File path = this.getSystemSaveFile();
                if (!path.exists()) {
                    return null;
                }
                fis = null;
                ObjectInputStream ois = null;
                try {
                    try {
                        fis = new FileInputStream(path);
                        ois = new ObjectInputStream(fis);
                        saveData = (SystemSaveData)ois.readObject();
                    }
                    catch (Exception e) {
                        Logger.fatal(MessageIDs.SAV0006F, (Throwable)e);
                        LoadFailureException lfe = new LoadFailureException("fail to load.", e);
                        throw lfe;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (Exception e) {
                            Logger.warn(MessageIDs.SAV0004W, (Throwable)e);
                        }
                    } else if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (Exception e) {
                            Logger.warn(MessageIDs.SAV0004W, (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                Object var7_9 = null;
                if (ois == null) break block16;
                try {
                    ois.close();
                }
                catch (Exception e) {
                    Logger.warn(MessageIDs.SAV0004W, (Throwable)e);
                }
                break block17;
            }
            if (fis == null) break block17;
            try {
                fis.close();
            }
            catch (Exception e) {
                Logger.warn(MessageIDs.SAV0004W, (Throwable)e);
            }
        }
        return saveData;
    }

    protected File getSaveFile(int id) {
        ResourceManager resources = ResourceManager.getInstance();
        return new File(resources.getLocationResources().getSaveDirectory(), "save" + FORMAT.format(new Integer(id)) + ".dat");
    }

    protected File getSystemSaveFile() {
        ResourceManager resources = ResourceManager.getInstance();
        return new File(resources.getLocationResources().getSaveDirectory(), "config.dat");
    }

    protected int getInitialSelectedIndexForSave(SaveDataInfo[] list) {
        if (list == null || list.length == 0) {
            throw new IllegalArgumentException("void list is specified.");
        }
        int selected = 0;
        SaveDataInfo info = null;
        int i = 0;
        while (i < list.length) {
            info = list[i];
            if (info == null) {
                selected = i;
                break;
            }
            if (list[selected] == null || info.getTimestamp().before(list[selected].getTimestamp())) {
                selected = i;
            }
            ++i;
        }
        return selected;
    }

    protected int getInitialSelectedIndexForLoad(SaveDataInfo[] list) {
        if (list == null || list.length == 0) {
            throw new IllegalArgumentException("void list is specified.");
        }
        if (this._lastIndex != -1) {
            return this._lastIndex;
        }
        int selected = 0;
        SaveDataInfo info = null;
        int i = 0;
        while (i < list.length) {
            info = list[i];
            if (info != null && (list[selected] == null || info.getTimestamp().after(list[selected].getTimestamp()))) {
                selected = i;
            }
            ++i;
        }
        return selected;
    }
}

