/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.session;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.scenario.SceneContext;

public class Session
implements Serializable {
    protected HashSet _sessionFlags = null;
    protected HashSet _systemFlags = null;
    protected Date _timestamp = null;
    protected SceneContext _sceneContext = null;
    protected HashMap _attributes = new HashMap(17);
    protected transient Thread _activeThread = null;

    public synchronized void setSceneContext(SceneContext context, Thread processThread) {
        this._sceneContext = context;
        this._activeThread = processThread;
    }

    public void setSceneContext(SceneContext context) {
        this.setSceneContext(context, Thread.currentThread());
    }

    public SceneContext getSceneContext() {
        return this._sceneContext;
    }

    public void declareSessionFlag(String flagID) {
        Logger.debug("[session] declare session flag: " + flagID);
        if (this.isActiveThread()) {
            this._sessionFlags.add(flagID);
        } else {
            Logger.debug("[session] canceled declaring session flag: " + flagID);
        }
    }

    public void undeclareSessionFlag(String flagID) {
        Logger.debug("[session] undeclare session flag: " + flagID);
        if (this.isActiveThread()) {
            this._sessionFlags.remove(flagID);
        } else {
            Logger.debug("[session] canceled undeclaring session flag: " + flagID);
        }
    }

    public boolean isDeclaredSessionFlag(String flagID) {
        return this._sessionFlags.contains(flagID);
    }

    public void declareSystemFlag(String flagID) {
        Logger.debug("[session] declare system flag: " + flagID);
        if (this.isActiveThread()) {
            this._systemFlags.add(flagID);
        } else {
            Logger.debug("[session] canceled declaring system flag: " + flagID);
        }
    }

    public void undeclareSystemFlag(String flagID) {
        Logger.debug("[session] undeclare system flag: " + flagID);
        if (this.isActiveThread()) {
            this._systemFlags.remove(flagID);
        } else {
            Logger.debug("[session] canceled undeclaring system flag: " + flagID);
        }
    }

    public boolean isDeclaredSystemFlag(String flagID) {
        return this._systemFlags.contains(flagID);
    }

    public void setSessionFlagSet(HashSet flagSet) {
        this._sessionFlags = flagSet;
    }

    public HashSet getSessionFlagSet() {
        return this._sessionFlags;
    }

    public Date getTimestamp() {
        return this._timestamp;
    }

    public void setSystemFlagSet(HashSet flagSet, Date timestamp) {
        if (this._timestamp == null || this._timestamp.before(timestamp)) {
            this._systemFlags = flagSet;
            this._timestamp = timestamp;
        }
    }

    public HashSet getSystemFlagSet() {
        return this._systemFlags;
    }

    public void setSessionAttribute(String name, Serializable value) {
        this._attributes.put(name, value);
    }

    public Object getSessionAttribute(String name) {
        return this._attributes.get(name);
    }

    protected boolean isActiveThread() {
        return this._activeThread == Thread.currentThread();
    }
}

