/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario.text;

import org.xml.sax.Attributes;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.scenario.FlagScope;
import tsukuba_bunko.peko.scenario.PSMLUtil;
import tsukuba_bunko.peko.scenario.text.TextCoordinator;
import tsukuba_bunko.peko.scenario.text.TextElementHandler;

public class ParagraphHandler
extends TextElementHandler {
    private StringBuffer _text = null;
    private String _flagID = null;

    public void performParagraph() {
        TextCoordinator coordinator = this.getTextCoordinator();
        coordinator.pushText(new String(this._text));
        this._text = new StringBuffer(48);
    }

    public void startDocument() {
        Logger.debug("[scene] start paragraph");
        this._text = new StringBuffer(48);
        this._flagID = null;
        this.getTextCoordinator().begin();
    }

    public void endDocument() {
        Logger.debug("[scene] end paragraph");
        this.performParagraph();
        this._text = null;
        this.stop();
        this.getTextCoordinator().commit();
        if (this._flagID != null) {
            this.getSceneContext().declareFlag(this._flagID, FlagScope.SESSION);
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
        if (localName.equals("wait")) {
            this.performParagraph();
            this.stop();
        } else if (localName.equals("p")) {
            this._flagID = PSMLUtil.getAttributeValue(attrs, "flag");
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
    }

    public void characters(char[] ch, int begin, int length) {
        this._text.append(ch, begin, length);
    }
}

