/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario.structure;

import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;
import org.xml.sax.Attributes;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.PekoSystem;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.scenario.ElementHandler;
import tsukuba_bunko.peko.scenario.NextSceneMapping;
import tsukuba_bunko.peko.scenario.PSMLUtil;
import tsukuba_bunko.peko.scenario.SceneContext;
import tsukuba_bunko.peko.scenario.structure.MessageIDs;

public class HeadHandler
extends ElementHandler {
    protected StringBuffer _text = null;
    protected NextSceneMapping _nextSceneMapping = null;
    protected String _condition = null;

    public void endDocument() {
        SceneContext context = this.getSceneContext();
        if (context.getSceneTitle() == null) {
            Logger.warn(MessageIDs.SCN5001W);
            context.setSceneTitle(context.getSceneName());
        }
        ResourceManager resources = ResourceManager.getInstance();
        PekoSystem.getInstance().getMainWindow().setTitle(String.valueOf(context.getSceneTitle()) + " - " + resources.getResource("game-info.title"));
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
        if (localName.equals("property")) {
            String name = PSMLUtil.getAttributeValue(attrs, "name");
            String file = PSMLUtil.getAttributeValue(attrs, "file");
            if (name != null && name.length() > 0) {
                this.getSceneContext().setProperty(name, PSMLUtil.getAttributeValue(attrs, "value"));
            } else if (file != null && file.length() > 0) {
                ResourceManager resources = ResourceManager.getInstance();
                URL sceneDir = resources.getLocationResources().getScenesDirecotryURL();
                URL fileURL = null;
                try {
                    fileURL = new URL(sceneDir, file);
                }
                catch (Exception e) {
                    Logger.warn(MessageIDs.SCN5002W, new Object[]{this.getSceneContext().getCurrentPath()}, e);
                    return;
                }
                Properties properties = new Properties();
                InputStream is = null;
                try {
                    try {
                        is = fileURL.openStream();
                        properties.load(is);
                    }
                    catch (Exception e) {
                        Logger.warn(MessageIDs.SCN5002W, new Object[]{this.getSceneContext().getCurrentPath()}, e);
                        Object var13_15 = null;
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                        }
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_16 = null;
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                Object var13_17 = null;
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                SceneContext context = this.getSceneContext();
                Iterator<Object> itr = properties.keySet().iterator();
                String key = null;
                while (itr.hasNext()) {
                    key = (String)itr.next();
                    context.setProperty(key, properties.getProperty(key));
                }
            }
        } else if ("next-scene".equals(localName)) {
            this._nextSceneMapping = this.getSceneContext().getNextSceneMapping();
        } else if (localName.equals("title")) {
            this._text = new StringBuffer();
        } else if (localName.equals("scene-ref")) {
            this._text = new StringBuffer();
            this._condition = PSMLUtil.getAttributeValue(attrs, "if");
            if (this._condition != null) {
                this._condition = this._condition.trim();
            }
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        if (localName.equals("title")) {
            if (this._text.length() == 0) {
                Logger.warn(MessageIDs.SCN5001W);
                this.getSceneContext().setSceneTitle(this.getSceneContext().getSceneName());
            } else {
                this.getSceneContext().setSceneTitle(new String(this._text));
            }
        } else if (localName.equals("scene-ref")) {
            if (this._text.length() > 0) {
                NextSceneMapping mapping = this.getSceneContext().getNextSceneMapping();
                String sceneName = new String(this._text).trim();
                if (this._condition == null || this._condition.length() == 0) {
                    mapping.setDefaultSceneMapping(sceneName);
                } else {
                    mapping.addNextSceneMapping(this._condition, sceneName);
                }
                this._condition = null;
            }
        } else if (localName.equals("next-scene")) {
            this._nextSceneMapping = null;
        }
        this._text = null;
    }

    public void characters(char[] ch, int begin, int length) {
        if (this._text != null) {
            this._text.append(ch, begin, length);
        }
    }
}

