/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario.stage;

import org.xml.sax.Attributes;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.canvas.stage.Actor;
import tsukuba_bunko.peko.resource.ResourceManager;
import tsukuba_bunko.peko.scenario.PSMLUtil;
import tsukuba_bunko.peko.scenario.stage.MessageIDs;
import tsukuba_bunko.peko.scenario.stage.StageCoordinator;
import tsukuba_bunko.peko.scenario.stage.StageElementHandler;

public class ActorHandler
extends StageElementHandler {
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
        Actor actor;
        String name = PSMLUtil.getAttributeValue(attrs, "name");
        if (name == null || name.length() == 0) {
            Logger.error(MessageIDs.SCN3001E, new Object[]{this.getSceneContext().getCurrentPath()});
            return;
        }
        String looks = PSMLUtil.getAttributeValue(attrs, "looks");
        String position = PSMLUtil.getAttributeValue(attrs, "position");
        StageCoordinator coordinator = this.getStageCoordinator();
        if (localName.equals("enter")) {
            actor = new Actor(name);
            actor.setLooks(looks);
            this.setPosition(actor, position == null ? "center" : position, "center");
            coordinator.enter(actor);
        } else if (localName.equals("action")) {
            actor = coordinator.getActor(name);
            if (actor == null) {
                Logger.warn(MessageIDs.SCN3002W, new Object[]{name, this.getSceneContext().getCurrentPath()});
            } else {
                if (looks != null) {
                    actor.setLooks(looks);
                }
                this.setPosition(actor, position, null);
            }
            coordinator.action(actor);
        } else if (localName.equals("exit") && coordinator.exit(name) == null) {
            Logger.warn(MessageIDs.SCN3002W, new Object[]{name, this.getSceneContext().getCurrentPath()});
        }
        String effect = PSMLUtil.getAttributeValue(attrs, "effect");
        if (effect == null) {
            ResourceManager resources = ResourceManager.getInstance();
            effect = (String)resources.getResource("peko.canvas.stage.default-effect.actor", true);
        }
        coordinator.updateStage(effect);
    }

    protected void setPosition(Actor actor, String position, String defaultPosition) {
        if (position == null) {
            return;
        }
        if ("center".equals(position)) {
            actor.setPosition(0);
        } else if ("left".equals(position)) {
            actor.setPosition(1);
        } else if ("right".equals(position)) {
            actor.setPosition(2);
        } else {
            try {
                actor.setPosition(Float.parseFloat(position));
            }
            catch (Exception e) {
                Logger.warn(MessageIDs.SCN3005W, new Object[]{this.getSceneContext().getCurrentPath()}, e);
                this.setPosition(actor, defaultPosition, null);
            }
        }
    }
}

