/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.scenario;

import java.util.HashMap;
import java.util.Map;
import tsukuba_bunko.peko.scenario.ElementHandler;
import tsukuba_bunko.peko.scenario.select.SelectHandler;
import tsukuba_bunko.peko.scenario.stage.ActorHandler;
import tsukuba_bunko.peko.scenario.stage.AtOnceHandler;
import tsukuba_bunko.peko.scenario.stage.BackgroundHandler;
import tsukuba_bunko.peko.scenario.stage.SlideHandler;
import tsukuba_bunko.peko.scenario.stage.SoundHandler;
import tsukuba_bunko.peko.scenario.structure.HeadHandler;
import tsukuba_bunko.peko.scenario.text.NewPageHandler;
import tsukuba_bunko.peko.scenario.text.ParagraphHandler;
import tsukuba_bunko.peko.scenario.util.FlagHandler;
import tsukuba_bunko.peko.scenario.util.SceneFlowHandler;
import tsukuba_bunko.peko.scenario.util.WaitHandler;

public class HandlerRegistry {
    private Map _registry = new HashMap(89);

    public void register(String elementName, ElementHandler handler) {
        this.register("http://tsukuba-bunko.org/ns/psml-scene", elementName, handler);
    }

    public void register(String namespaceURI, String localName, ElementHandler handler) {
        Map handlers = this.getElementHandlers(namespaceURI);
        handlers.put(localName, handler);
    }

    public void unregister(String elementName) {
        this.unregister("http://tsukuba-bunko.org/ns/psml-scene", elementName);
    }

    public void unregister(String namespaceURI, String localName) {
        Map handlers = this.getElementHandlers(namespaceURI);
        handlers.remove(localName);
    }

    public ElementHandler getElementHandler(String elementName) {
        return this.getElementHandler("http://tsukuba-bunko.org/ns/psml-scene", elementName);
    }

    public ElementHandler getElementHandler(String namespaceURI, String localName) {
        Map handlers = this.getElementHandlers(namespaceURI);
        return (ElementHandler)handlers.get(localName);
    }

    private Map getElementHandlers(String namespaceURI) {
        HashMap handlers = (HashMap)this._registry.get(namespaceURI);
        if (handlers == null) {
            handlers = new HashMap(89);
            this._registry.put(namespaceURI, handlers);
        }
        return handlers;
    }

    public static HandlerRegistry newInstance() {
        HandlerRegistry instance = new HandlerRegistry();
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "select", new SelectHandler());
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "flag", new FlagHandler());
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "wait", new WaitHandler());
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "scene-flow", new SceneFlowHandler());
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "np", new NewPageHandler());
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "p", new ParagraphHandler());
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "head", new HeadHandler());
        ActorHandler actorHandler = new ActorHandler();
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "enter", actorHandler);
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "action", actorHandler);
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "exit", actorHandler);
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "background", new BackgroundHandler());
        SlideHandler slideHandler = new SlideHandler();
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "show-slide", slideHandler);
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "hide-slide", slideHandler);
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "at-once", new AtOnceHandler());
        SoundHandler soundHandler = new SoundHandler();
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "play-bgm", soundHandler);
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "stop-bgm", soundHandler);
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "play-se", soundHandler);
        instance.register("http://tsukuba-bunko.org/ns/psml-scene", "stop-se", soundHandler);
        return instance;
    }
}

