/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.resource;

import java.net.URL;
import tsukuba_bunko.peko.InitializationError;
import tsukuba_bunko.peko.Logger;
import tsukuba_bunko.peko.resource.IconDeserializer;
import tsukuba_bunko.peko.resource.LocationConfigurator;
import tsukuba_bunko.peko.resource.LocationResources;
import tsukuba_bunko.peko.resource.MessageIDs;
import tsukuba_bunko.peko.resource.PekoResourceLoader;
import tsukuba_bunko.resource.DeserializerMapping;
import tsukuba_bunko.resource.Resources;

public class ResourceManager {
    protected static final String RES_MESSAGE = "messages.xml";
    protected static final String RES_SYSTEM = "system.xml";
    protected static final String RES_MENU = "menu.xml";
    protected static final String RES_DIALOG = "dialog.xml";
    protected static final String RES_CANVAS = "canvas.xml";
    protected static final String RES_GAME = "game-info.xml";
    protected static final String RES_TITLE = "title.xml";
    private static ResourceManager _instance = null;
    private PekoResourceLoader _loader = null;
    private Resources _resources = null;
    private LocationResources _locationResources = null;
    static /* synthetic */ Class class$0;

    protected ResourceManager() {
    }

    public boolean exists(String resourceID) {
        return this._resources.getResource(resourceID) != null;
    }

    public Object getResource(String resourceID) {
        return this.getResource(resourceID, false);
    }

    public Object getResource(String resourceID, boolean nowarn) {
        Object resource = this._resources.getResource(resourceID);
        if (!nowarn && resource == null) {
            Logger.warn(MessageIDs.RES0001W.getMessage(new Object[]{resourceID}));
        }
        return resource;
    }

    public LocationResources getLocationResources() {
        return this._locationResources;
    }

    private PekoResourceLoader getResourceLoader() {
        try {
            if (this._loader == null) {
                this._loader = new PekoResourceLoader();
            }
            return this._loader;
        }
        catch (Exception e) {
            InitializationError ie = new InitializationError("fail to create instance of PekoResourceLoader", e);
            Logger.fatal(MessageIDs.RES0014F, (Throwable)e);
            throw ie;
        }
    }

    private void loadLogMessages() {
        try {
            URL resourceURL = this.getClass().getClassLoader().getResource(RES_MESSAGE);
            if (resourceURL == null) {
                InitializationError ie = new InitializationError("missing resource file of log messgages.");
                Logger.fatal("[RES9998F] missing resource file of log messgages.", (Throwable)ie);
                throw ie;
            }
            Logger.debug("loading log messages from " + resourceURL.toString());
            this._resources = Resources.newInstance(resourceURL);
        }
        catch (Exception e) {
            InitializationError ie = new InitializationError("fail to load resources of log messages.", e);
            Logger.fatal("[RES9999F] fail to load resources of log messages.", (Throwable)ie);
            throw ie;
        }
    }

    private void loadSystemConfigurationResources() {
        try {
            URL resourceURL = this.getClass().getClassLoader().getResource(RES_SYSTEM);
            if (resourceURL == null) {
                InitializationError ie = new InitializationError("missing resource file of PVNS resource.");
                Logger.fatal(MessageIDs.RES0002F, new Object[]{RES_SYSTEM}, ie);
                throw ie;
            }
            Logger.debug("loadingresources of system configuration from " + resourceURL.toString());
            PekoResourceLoader loader = this.getResourceLoader();
            loader.loadResource(resourceURL, this._resources);
        }
        catch (Exception e) {
            InitializationError ie = new InitializationError("fail to load resources of system configuration", e);
            Logger.fatal(MessageIDs.RES0003F, new Object[]{RES_SYSTEM}, ie);
            throw ie;
        }
        LocationConfigurator configurator = new LocationConfigurator();
        this._locationResources = configurator.configure(this._resources);
    }

    private void loadMenuResources() {
        try {
            URL resourceURL = this.getClass().getClassLoader().getResource(RES_MENU);
            if (resourceURL == null) {
                InitializationError ie = new InitializationError("missing resource file of menu items.");
                Logger.fatal(MessageIDs.RES0002F, new Object[]{RES_MENU}, ie);
                throw ie;
            }
            Logger.debug("loading resources of menu items from " + resourceURL.toString());
            PekoResourceLoader loader = this.getResourceLoader();
            loader.loadResource(resourceURL, this._resources);
        }
        catch (Exception e) {
            InitializationError ie = new InitializationError("fail to load resources of menu item configuration", e);
            Logger.fatal(MessageIDs.RES0003F, new Object[]{RES_SYSTEM}, ie);
            throw ie;
        }
    }

    private void loadDialogConfigurationResources() {
        try {
            URL resourceURL = this.getClass().getClassLoader().getResource(RES_DIALOG);
            if (resourceURL == null) {
                InitializationError ie = new InitializationError("missing resource file of dialog configuration.");
                Logger.fatal(MessageIDs.RES0002F, new Object[]{RES_DIALOG}, ie);
                throw ie;
            }
            Logger.debug("loading resources of dialog configuration from " + resourceURL.toString());
            PekoResourceLoader loader = this.getResourceLoader();
            loader.loadResource(resourceURL, this._resources);
        }
        catch (Exception e) {
            InitializationError ie = new InitializationError("fail to load resources of dialog configuration", e);
            Logger.fatal(MessageIDs.RES0003F, new Object[]{RES_DIALOG}, ie);
            throw ie;
        }
    }

    private void loadCanvasConfigurationResources() {
        try {
            URL resourceURL = this.getClass().getClassLoader().getResource(RES_CANVAS);
            if (resourceURL == null) {
                InitializationError ie = new InitializationError("missing resource file of canvas configuration.");
                Logger.fatal(MessageIDs.RES0002F, new Object[]{RES_CANVAS}, ie);
                throw ie;
            }
            Logger.debug("loading resources of canvas configuration from " + resourceURL.toString());
            PekoResourceLoader loader = this.getResourceLoader();
            loader.loadResource(resourceURL, this._resources);
        }
        catch (Exception e) {
            InitializationError ie = new InitializationError("fail to load resources of canvas configuration", e);
            Logger.fatal(MessageIDs.RES0003F, new Object[]{RES_CANVAS}, ie);
            throw ie;
        }
    }

    private void loadTitleConfigurationResources() {
        try {
            URL resourceURL = this.getClass().getClassLoader().getResource(RES_TITLE);
            if (resourceURL == null) {
                InitializationError ie = new InitializationError("missing resource file of title configuration.");
                Logger.fatal(MessageIDs.RES0002F, new Object[]{RES_TITLE}, ie);
                throw ie;
            }
            Logger.debug("loading resources of title configuration from " + resourceURL.toString());
            PekoResourceLoader loader = this.getResourceLoader();
            loader.loadResource(resourceURL, this._resources);
        }
        catch (Exception e) {
            InitializationError ie = new InitializationError("fail to load resources of title configuration", e);
            Logger.fatal(MessageIDs.RES0003F, new Object[]{RES_TITLE}, ie);
            throw ie;
        }
    }

    private void loadGameInfoResources() {
        try {
            URL resourceURL = this.getClass().getClassLoader().getResource(RES_GAME);
            if (resourceURL == null) {
                InitializationError ie = new InitializationError("missing resource file of game information resource.");
                Logger.fatal(MessageIDs.RES0002F, new Object[]{RES_GAME}, ie);
                throw ie;
            }
            Logger.debug("loading game information resources from " + resourceURL.toString());
            PekoResourceLoader loader = this.getResourceLoader();
            DeserializerMapping mapping = loader.getDeserializerMapping();
            IconDeserializer deserializer = (IconDeserializer)mapping.getResourceDeserializer("peko:icon");
            deserializer.setBaseURL(this._locationResources.getMiscDirecotryURL());
            loader.loadResource(resourceURL, this._resources);
        }
        catch (Exception e) {
            InitializationError ie = new InitializationError("fail to load resources of game information resource", e);
            Logger.fatal(MessageIDs.RES0003F, new Object[]{RES_GAME}, ie);
            throw ie;
        }
    }

    private void initialize() {
        Logger.debug("[resource] start initializing ResourceManager.");
        this.loadLogMessages();
        this.loadSystemConfigurationResources();
        this.loadMenuResources();
        this.loadDialogConfigurationResources();
        this.loadCanvasConfigurationResources();
        this.loadTitleConfigurationResources();
        this.loadGameInfoResources();
        Logger.debug("[resource] finish initializing ResourceManager.");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ResourceManager getInstance() {
        if (_instance != null) return _instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("tsukuba_bunko.peko.resource.ResourceManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (_instance != null) return _instance;
            _instance = new ResourceManager();
            _instance.initialize();
            // ** MonitorExit[var0] (shouldn't be in output)
            return _instance;
        }
    }
}

