/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.resource;

import java.util.Locale;
import org.xml.sax.Attributes;
import tsukuba_bunko.resource.BasicDeserializer;

public class LocaleDeserializer
extends BasicDeserializer {
    private StringBuffer _text = null;
    private String _country = null;
    private String _language = null;

    public void startDocument() {
        this._country = null;
        this._language = null;
    }

    public void endDocument() {
        if (this._language != null) {
            if (this._country != null) {
                this.setValue(new Locale(this._language, this._country));
            } else {
                this.setValue(new Locale(this._language));
            }
        } else {
            this.setValue(Locale.getDefault());
        }
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) {
        if ("language".equals(localName) || "country".equals(localName)) {
            this._text = new StringBuffer();
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) {
        String country;
        if ("language".equals(localName)) {
            String language = new String(this._text).trim();
            if (language.length() > 0) {
                this._language = language;
            }
        } else if ("country".equals(localName) && (country = new String(this._text).trim()).length() > 0) {
            this._country = country;
        }
        this._text = null;
    }

    public void characters(char[] ch, int begin, int length) {
        if (this._text != null) {
            this._text.append(ch, begin, length);
        }
    }
}

