/*
 * Decompiled with CFR 0.152.
 */
package tsukuba_bunko.peko.canvas.text;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.io.Serializable;
import java.text.AttributedString;
import tsukuba_bunko.peko.canvas.text.Page;

public class Line
implements Serializable {
    private transient TextLayout _textLayout = null;
    private transient Shape _shape = null;
    private float _lineSpan = 0.0f;
    private Color _foreground = null;
    private Color _shadowColor = Color.black;
    private String _text = null;

    public void setForeground(Color color) {
        this._foreground = color;
    }

    public Color getForeground() {
        return this._foreground;
    }

    public void setShadowColor(Color color) {
        this._shadowColor = color;
    }

    public Color getShadowColor() {
        return this._shadowColor;
    }

    public void setText(String text) {
        this._text = text;
    }

    public String getText() {
        return this._text;
    }

    public void setTextLayout(TextLayout layout) {
        this._textLayout = layout;
        this._shape = layout.getOutline(null);
    }

    public TextLayout getTextLayout() {
        return this._textLayout;
    }

    public void setLineSpan(float lineSpan) {
        this._lineSpan = lineSpan;
    }

    public float getLineSpan() {
        return this._lineSpan;
    }

    public float getAscent() {
        return this._textLayout.getAscent() + this._lineSpan;
    }

    public float getDescent() {
        return this._textLayout.getDescent();
    }

    public float getAdavance() {
        return this._textLayout.getAdvance();
    }

    public void draw(Graphics2D g2, float x, float y) {
        Graphics2D g = (Graphics2D)g2.create();
        g.translate((int)x + 2, (int)y + 2);
        if (this._shadowColor == null) {
            g.setColor(Color.black);
        } else {
            g.setColor(this._shadowColor);
        }
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.fill(this._shape);
        Color original = g2.getColor();
        if (this._foreground != null) {
            g2.setColor(this._foreground);
        }
        this._textLayout.draw(g2, x, y);
        g2.setColor(original);
    }

    public void prepare(Page page) {
        if (this._textLayout == null) {
            AttributedString astring = new AttributedString(this._text);
            astring.addAttribute(TextAttribute.FONT, page.getDefaultFont());
            astring.addAttribute(TextAttribute.FOREGROUND, page.getForeground());
            this.setTextLayout(new TextLayout(astring.getIterator(), page.getFontRenderContext()));
        }
    }
}

